% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itan.R
\name{calcularNotas}
\alias{calcularNotas}
\title{Cálculo de notas}
\usage{
calcularNotas(
  puntajes,
  pjeMax = max(puntajes),
  notaMin = 1,
  notaMax = 7,
  notaAprobacion = 4,
  prema = 0.6
)
}
\arguments{
\item{puntajes}{Un data frame con los puntajes obtenidos por los estudiantes
en la prueba.}

\item{pjeMax}{El puntaje máximo posible de alcanzar en la prueba.}

\item{notaMin}{La nota mínima otorgada al estudiante sin puntaje.}

\item{notaMax}{La nota máxima otorgada al estudiante con mejor puntaje.}

\item{notaAprobacion}{La nota necesaria para aprobar la prueba.}

\item{prema}{Porcentaje de rendimiento mínimo aceptable. Corresponde
a la proporción del puntaje máximo necesario para obtener
la nota de aprobación en la prueba.}
}
\value{
Un data frame con las notas obtenidas por los estudiantes en la prueba.
}
\description{
Calcula la nota obtenida por cada estudiante en función de
su puntaje alcanzado en la prueba. Se utiliza el \href{https://es.wikipedia.org/wiki/Calificaciones_escolares_en_Chile}{sistema de calificación
utilizado en Chile}.
}
\examples{
respuestas <- datos[,-1]
respuestasCorregidas <- corregirRespuestas(respuestas, clave)
puntaje <- calcularPuntajes(respuestasCorregidas)
nota <- calcularNotas(puntaje)
cbind(id=datos[1], puntaje, nota)

}
\references{
Pumarino, J. Escala de notas: Explicación de fórmula general y cálculo específico.
Recuperado de \url{https://escaladenotas.cl/?nmin=1.0&nmax=7.0&napr=4.0&exig=60.0&pmax=100.0&explicacion=1}
}
\seealso{
\code{\link{corregirRespuestas}}, \code{\link{calcularPuntajes}},
\code{\link{datos}} y \code{\link{clave}}.
}
