% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iseq.R
\name{iseq}
\alias{iseq}
\alias{iseq_along}
\title{Iterators for sequence generation}
\usage{
iseq(
  from = 1,
  to = NULL,
  by = NULL,
  length_out = NULL,
  along_with = NULL,
  ...,
  recycle = FALSE,
  chunkSize,
  chunks
)

iseq_along(along_with, ...)
}
\arguments{
\item{from}{the starting value of the sequence.}

\item{to}{the end value of the sequence.}

\item{by}{increment of the sequence.}

\item{length_out}{desired length of the sequence. A non-negative number,
which for \code{seq} will be rounded up if fractional.}

\item{along_with}{the length of the sequence will match the length of this}

\item{...}{Unused.}

\item{recycle}{Whether to restart the sequence after it reaches \code{to}.}

\item{chunkSize}{Optional; return this many values per call.}

\item{chunks}{Optional; return this many chunks.}
}
\value{
an \link{iteror}.
}
\description{
Constructs iterators that generate regular sequences that follow the
\code{\link[base]{seq}} family.
}
\details{
The \code{iseq} function generates a sequence of values beginning with
\code{from} and ending with \code{to}. The sequence of values between are
determined by the \code{by}, \code{length_out}, and \code{along_with}
arguments. The \code{by} argument determines the step size of the sequence,
whereas \code{length_out} and \code{along_with} determine the length of the
sequence. If \code{by} is not given, then it is determined by either
\code{length_out} or \code{along_with}. By default, neither are given, in
which case \code{by} is set to 1 or -1, depending on whether \code{to >
from}.
}
\examples{
it <- iseq(from=2, to=5)
unlist(as.list(it)) == 2:5
}
\seealso{
icount icountn
}
