% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduce.R
\name{reduce}
\alias{reduce}
\alias{reduce.iteror}
\alias{i_accum}
\alias{sum.iteror}
\alias{prod.iteror}
\title{Compute the sum, product, or general reduction of an iterator.}
\usage{
reduce(obj, fun = `+`, init = 0, ...)

\method{reduce}{iteror}(obj, fun = `+`, init = 0, ...)

i_accum(obj, fun = `+`, init = 0, ...)

\method{sum}{iteror}(..., na.rm = FALSE)

\method{prod}{iteror}(..., na.rm = FALSE)
}
\arguments{
\item{obj}{an iterable object}

\item{fun}{A function of as least two arguments.}

\item{init}{A starting value.}

\item{...}{Extra parameters will be passed to each call to \code{fun}.}

\item{na.rm}{Whether to drop NA values when computing sum or prod.}
}
\value{
The result of accumulation.
}
\description{
\code{reduce(obj, fun)} applies a 2-argument function \code{fun} between
successive elements of obj. For example if \code{fun} is \code{+},
\verb{reduce(it, }+\verb{, init=0)} computes \code{0 + nextElem(it) + nextElem(it) + nextElem(it) + ...} until the iterator finishes,
and returns the final value.

\code{i_accum(obj)} returns the iterator containing
each intermediate result. The default settings
produce a cumulative sum.

\code{sum.iteror(it)} is equivalent to \code{reduce(it, `+`)}

\code{prod.iteror(it)} is equivalent to \code{reduce(it, `*`)}.
}
\examples{
it <- icount(5)
total <- reduce(it, `+`) # 15

it <- icount(5)
reduce(it, paste0, "") # "12345"

it <- icount(5)
reduce(it, `*`, init=1) # 120

# triangular numbers: 1, 1+2, 1+2+3, ...
take(i_accum(icount()), 10, 'numeric')
}
\author{
Peter Meilstrup
}
