% Generated by roxygen2 (4.0.1): do not edit by hand
\name{idropwhile}
\alias{idropwhile}
\title{Iterator that drops elements until the predicate function returns FALSE}
\usage{
idropwhile(predicate, object)
}
\arguments{
\item{predicate}{a function that determines whether an element is \code{TRUE}
or \code{FALSE}. The function is assumed to take only one argument.}

\item{object}{an iterable object}
}
\value{
iterator object
}
\description{
Constructs an iterator that drops elements from the iterable \code{object} as
long as the \code{predicate} function is true; afterwards, every element of
\code{iterable} object is returned.
}
\details{
Because the iterator does not return any elements until the \code{predicate}
first becomes false, there may have a lengthy start-up time before elements
are returned.
}
\examples{
# Filters out numbers exceeding 3
not_too_large <- function(x) {
  x <= 3
}
it <- idropwhile(not_too_large, 1:8)
as.list(it)

# Same approach but uses an anonymous function
it2 <- idropwhile(function(x) x <= 10, seq(2, 20, by=2))
as.list(it2)
}

