% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PER_CI.R
\name{PER_CI}
\alias{PER_CI}
\title{Construct a two-sided confidence interval for the pooled
effect ratio}
\usage{
PER_CI(
  R_t,
  R_c,
  d_t,
  d_c,
  lower,
  upper,
  Q = NULL,
  meshsize = 0.001,
  alpha = 0.05
)
}
\arguments{
\item{R_t}{A length-K vector where K is equal to the number of
clusters and the kth entry equal to
the sum of unit-level outcomes in the encouraged cluster
of the kth matched pair of two clusters.}

\item{R_c}{A length-K vector where K is equal to the number of
clusters and the kth entry equal to
the sum of unit-level outcomes in the control cluster
of the kth matched pair of two clusters.}

\item{d_t}{A length-K vector where K is equal to the number of
clusters and the kth entry equal to the sum of unit-level
treatment received in the encouraged cluster
of the kth matched pair of two clusters.}

\item{d_c}{A length-K vector where K is equal to the number of
clusters and the kth entry equal to the sum of unit-level
treatment received in the control cluster
of the kth matched pair of two clusters.}

\item{lower, upper}{The lower and upper endpoints of the interval to be searched.}

\item{Q}{A K times p design matrix containing the covariate information.
See Details of the function \code{\link{PER}}.}

\item{meshsize}{The meshsize of the grid search.}

\item{alpha}{The level of the confidence interval.}
}
\value{
A length-2 vector of two endpoints of the confidence interval.
}
\description{
\code{PER_CI} returns the two-sided level-alpha confidence
interval of the pooled effect ratio in a cluster-randomized
encouragement experiment.
}
\details{
\code{PER_CI} constructs a two-sided level-alpha confidence interval
by interting the corresponding hypothesis test for the pooled effect
ratio. See \code{\link{PER}} for details on the hypothesis tesing.
\code{PER_CI} conducts a grid search with user-specified endpoints
and meshsize in order to construct the confidence interval.
}
\examples{
R_t = encouraged_clusters$aggregated_outcome
R_c = control_clusters$aggregated_outcome
d_t = encouraged_clusters$aggregated_treatment
d_c = control_clusters$aggregated_treatment

# Construct 95\% CI for the pooled effect ratio estimand
# using the default sample variance estimator, i.e.,
# setting Q = NULL.
CI = PER_CI(R_t, R_c, d_t, d_c, lower = -0.1, upper = 0.1,
           alpha = 0.05)

}
