% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/double_rank.R
\name{double_rank}
\alias{double_rank}
\title{Two-sided double-rank test for Fisher's sharp null
hypothesis in a cluster-level proportional treatment effect model}
\usage{
double_rank(beta_0, R_t, R_c, d_t, d_c, Z_t, Z_c, psi = NULL)
}
\arguments{
\item{beta_0}{The magnitude of the proportional treatment effect to
be tested.}

\item{R_t}{A length-K vector where K is equal to the number of
clusters and the kth entry equal to
the sum of unit-level outcomes in the encouraged cluster
of the kth matched pair of two clusters.}

\item{R_c}{A length-K vector where K is equal to the number of
clusters and the kth entry equal to
the sum of unit-level outcomes in the control cluster
of the kth matched pair of two clusters.}

\item{d_t}{A length-K vector where K is equal to the number of
clusters and the kth entry equal to the sum of unit-level
treatment received in the encouraged cluster
of the kth matched pair of two clusters.}

\item{d_c}{A length-K vector where K is equal to the number of
clusters and the kth entry equal to the sum of unit-level
treatment received in the control cluster
of the kth matched pair of two clusters.}

\item{Z_t}{A length-K vector where K is equal to the number of
clusters and the kth entry equal to the encoruagement dose,
i.e., the magnitude of the instrumental variable, of the
encouraged cluster in the kth matched pair of two clusters.}

\item{Z_c}{A length-K vector where K is equal to the number of
clusters and the kth entry equal to the encoruagement dose,
i.e., the magnitude of the instrumental variable, of the
control cluster in the kth matched pair of two clusters.}

\item{psi}{A function specifying the score used in the test statistic.
See Details.}
}
\value{
A list of five elements: two-sided p-value, deviate, test statistics,
        expectation of the test statistic under the null hypothesis,
        and variance of the test statistic under the null hypothesis.
}
\description{
\code{double_rank} returns the two-sided p-value testing
Fisher's sharp null hypothesis in a cluster-level proportional
treatment effect model.
}
\details{
Double-rank test statistics is a flexible family of nonparametric
test statistics. Function \code{psi} is a function that specifies
the relationship between d_k, the normalized rank of the absolute
treated-minus-control dose difference in the instrumental variable,
and q_k, the normalized rank of the absoluve treated-minus-control
dose difference in the observed outcome. For instance, psi(d_k, q_k)
= 1 yields the sign test, psi(d_k, q_k) = q_k yields the Wilcoxon
signed rank test. The default setting, psi(d_k, q_k) = d_k * q_k, yields
the dose-weighted signed rank test.
}
\examples{
R_t = encouraged_clusters$aggregated_outcome
R_c = control_clusters$aggregated_outcome
d_t = encouraged_clusters$aggregated_treatment
d_c = control_clusters$aggregated_treatment
Z_t = encouraged_clusters$IV
Z_c = control_clusters$IV


# Test beta = 0 in the proportional treatment effect
# model with the help of the double rank test using
# default psi(d_k, q_k) = d_k * q_k:
res = double_rank(0, R_t, R_c, d_t, d_c, Z_t, Z_c)

# Define a new psi function: psi(d_k, q_k) = q_k
psi_2 <- function(x, y) y

# Using psi_2 and the double rank test is reduced to the
#Wilcoxon signed rank test.
res_2 = double_rank(0, R_t, R_c, d_t, d_c,
     Z_t, Z_c, psi = psi_2)


}
