% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monobound.R
\name{genmonoA}
\alias{genmonoA}
\title{Generate components of the monotonicity constraints}
\usage{
genmonoA(
  A0,
  A1,
  sset,
  uname,
  gridobj,
  gstar0,
  gstar1,
  m0.dec,
  m0.inc,
  m1.dec,
  m1.inc,
  mte.dec,
  mte.inc,
  solution.m0.min = NULL,
  solution.m1.min = NULL,
  solution.m0.max = NULL,
  solution.m1.max = NULL,
  audit.tol,
  direct
)
}
\arguments{
\item{A0}{the matrix of values from evaluating the MTR for control
observations over the grid generated to perform the audit. This
matrix will be incorporated into the final constraint matrix
for the monotonicity conditions.}

\item{A1}{the matrix of values from evaluating the MTR for control
observations over the grid generated to perform the audit. This
matrix will be incorporated into the final constraint matrix
for the monotonicity conditions.}

\item{sset}{a list containing the point estimates and gamma
components associated with each element in the S-set.}

\item{uname}{Name of unobserved variable.}

\item{gridobj}{a list containing the grid over which the
monotonicity and boundedness conditions are imposed on.}

\item{gstar0}{set of expectations for each terms of the MTR for the
control group.}

\item{gstar1}{set of expectations for each terms of the MTR for the
control group.}

\item{m0.dec}{boolean, indicating whether the MTR for the control
group is monotone decreasing.}

\item{m0.inc}{boolean, indicating whether the MTR for the control
group is monotone increasing.}

\item{m1.dec}{boolean, indicating whether the MTR for the treated
group is monotone decreasing.}

\item{m1.inc}{boolean, indicating whether the MTR for the treated
group is monotone increasing.}

\item{mte.dec}{boolean, indicating whether the MTE is monotone
decreasing.}

\item{mte.inc}{boolean, indicating whether the MTE is monotone
increasing.}

\item{solution.m0.min}{vector, the coefficients for the MTR for
\code{D = 0} corresponding to the lower bound of the target
parameter. If passed, this will initiate checks of shape
constraints.}

\item{solution.m1.min}{vector, the coefficients for the MTR for
\code{D = 1} corresponding to the lower bound of the target
parameter. If passed, this will initiate checks of shape
constraints.}

\item{solution.m0.max}{vector, the coefficients for the MTR for
\code{D = 0} corresponding to the upper bound of the target
parameter. If passed, this will initiate checks of shape
constraints.}

\item{solution.m1.max}{vector, the coefficients for the MTR for
\code{D = 1} corresponding to the upper bound of the target
parameter. If passed, this will initiate checks of shape
constraints.}

\item{audit.tol}{feasibility tolerance when performing the
audit. By default to set to be equal \code{1e-06}. This
parameter should only be changed if the feasibility tolerance
of the solver is changed, or if numerical issues result in
discrepancies between the solver's feasibility check and the
audit.}

\item{direct}{boolean, set to \code{TRUE} if the direct MTR
regression is used.}
}
\value{
constraint matrix for the LP/QCQP problem. The matrix pertains
    only to the monotonicity conditions on the MTR and MTE declared
    by the user.
}
\description{
This function generates the matrix and vectors associated with the
monotonicity constraints declared by the user. It takes in a grid
of the covariates on which the shape constraints are defined, and then
calculates the values of the MTR and MTE over the grid. The
matrices characterizing the monotonicity conditions can then be
obtained by taking first differences over the grid of the
unobservable term, within each set of values in the grid of
covariate values.
}
