% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splines.R
\name{splinesBasis}
\alias{splinesBasis}
\title{Evaluating splines basis functions}
\usage{
splinesBasis(x, knots, degree, intercept = TRUE, i, boundary.knots = c(0, 1))
}
\arguments{
\item{x}{vector, the values at which to evaluate the basis
function.}

\item{knots}{vector, the internal knots.}

\item{degree}{integer, the degree of the splines.}

\item{intercept}{boolean, default set to \code{TRUE}. This includes
an additional component to the basis splines so that the
splines are a partition of unity (i.e. the sum of all
components equal to 1).}

\item{i}{integer, the basis component to be evaluated.}

\item{boundary.knots}{vector, default is \code{c(0, 1)}.}
}
\value{
scalar.
}
\description{
This function evaluates the splines basis functions. Unlike the
\code{bSpline} in the \code{splines2} package, this function
returns the value of a single spline basis, rather than a vector of
values for all the spline basis functions.
}
