% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivregMethods.R
\name{coef.ivreg}
\alias{coef.ivreg}
\alias{ivregMethods}
\alias{vcov.ivreg}
\alias{bread.ivreg}
\alias{estfun.ivreg}
\alias{terms.ivreg}
\alias{model.matrix.ivreg}
\alias{predict.ivreg}
\alias{print.ivreg}
\alias{update.ivreg}
\alias{residuals.ivreg}
\alias{Effect.ivreg}
\alias{formula.ivreg}
\alias{find_formula.ivreg}
\alias{alias.ivreg}
\alias{qr.ivreg}
\alias{vcovHC.ivreg}
\alias{model.matrix.ivreg_projected}
\alias{weights.ivreg}
\title{Methods for \code{"ivreg"} Objects}
\usage{
\method{coef}{ivreg}(object, component = c("stage2", "stage1"), complete = TRUE, ...)

\method{vcov}{ivreg}(object, component = c("stage2", "stage1"), complete = TRUE, ...)

\method{bread}{ivreg}(x, ...)

\method{estfun}{ivreg}(x, ...)

\method{vcovHC}{ivreg}(x, ...)

\method{terms}{ivreg}(x, component = c("regressors", "instruments", "full"), ...)

\method{model.matrix}{ivreg}(
  object,
  component = c("regressors", "projected", "instruments"),
  ...
)

\method{model.matrix}{ivreg_projected}(object, ...)

\method{predict}{ivreg}(
  object,
  newdata,
  type = c("response", "terms"),
  na.action = na.pass,
  se.fit = FALSE,
  interval = c("none", "confidence", "prediction"),
  df = Inf,
  level = 0.95,
  weights,
  ...
)

\method{print}{ivreg}(x, digits = max(3, getOption("digits") - 3), ...)

\method{update}{ivreg}(object, formula., ..., evaluate = TRUE)

\method{residuals}{ivreg}(
  object,
  type = c("response", "projected", "regressors", "working", "deviance", "pearson",
    "partial", "stage1"),
  ...
)

\method{Effect}{ivreg}(focal.predictors, mod, ...)

\method{formula}{ivreg}(x, component = c("complete", "regressors", "instruments"), ...)

\method{find_formula}{ivreg}(x, ...)

\method{alias}{ivreg}(object, ...)

\method{qr}{ivreg}(x, ...)

\method{weights}{ivreg}(object, type = c("variance", "robustness"), ...)
}
\arguments{
\item{object, model, mod}{An object of class \code{"ivreg"}.}

\item{component}{For \code{\link{terms}}, \code{"regressors"}, \code{"instruments"}, or \code{"full"}; 
for \code{\link{model.matrix}}, \code{"projected"}, \code{"regressors"}, or \code{"instruments"};
for \code{\link{formula}}, \code{"regressors"}, \code{"instruments"},  or \code{"complete"};
for \code{\link{coef}} and \code{\link{vcov}}, \code{"stage2"} or \code{"stage1"}.}

\item{complete}{If \code{TRUE}, the default, the returned coefficient vector (for \code{coef}) or coefficient-covariance matrix (for \code{vcov}) includes elements for aliased regressors.}

\item{...}{arguments to pass down.}

\item{x}{An object of class \code{"ivreg"}.}

\item{newdata}{Values of predictors for which to obtain predicted values; if missing
predicted (i.e., fitted) values are computed for the data to which the model was fit.}

\item{type}{For \code{predict}, one of \code{"response"} (the default)  or \code{"terms"};
for \code{residuals}, one of \code{"response"} (the default), \code{"projected"}, \code{"regressors"},
\code{"working"}, \code{"deviance"}, \code{"pearson"}, or \code{"partial"}; 
\code{type = "working"} and \code{"response"} are equivalent, as are 
\code{type = "deviance"} and \code{"pearson"}; for \code{weights}, \code{"variance"} (the default)
for invariance-variance weights (which is \code{NULL} for an unweighted fit) 
or \code{"robustness"} for robustness weights (available for M or MM estimation).}

\item{na.action}{\code{na} method to apply to predictor values for predictions; default is \code{\link{na.pass}}.}

\item{se.fit}{Compute standard errors of predicted values (default \code{FALSE}).}

\item{interval}{Type of interval to compute for predicted values: \code{"none"} (the default),
\code{"confidence"} for confidence intervals for the expected response, or \code{"prediction"} for
prediction intervals for future observations.}

\item{df}{For \code{predict}, degrees of freedom for computing t-distribution confidence- or prediction-interval limits; the
default, \code{Inf}, is equivalent to using the normal distribution; if \code{NULL}, 
\code{df} is taken from the residual degrees of freedom for the model.
These tests are not to be confused with the \emph{regression diagnostics} provided elsewhere in the \pkg{ivreg}
package: see \code{\link{ivregDiagnostics}}.}

\item{level}{for confidence or prediction intervals, default \code{0.95}.}

\item{weights}{Either a numeric vector or a one-sided formula to provide weights for prediction
intervals when the fit is weighted. If \code{weights} and \code{newdata} are missing, the weights
are those used for fitting the model.}

\item{digits}{For printing.}

\item{formula.}{To update model.}

\item{evaluate}{If \code{TRUE}, the default, the updated model is evaluated; if \code{FALSE} the updated call is returned.}

\item{focal.predictors}{Focal predictors for effect plot, see \code{\link[effects:effect]{Effect}}.}
}
\description{
Various methods for processing \code{"ivreg"} objects; for diagnostic methods,
  see \code{\link{ivregDiagnostics}}.
}
\seealso{
\code{\link{ivreg}}, \code{\link{ivreg.fit}}, \code{\link{ivregDiagnostics}}
}
