% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relation.R
\name{allen-relation-detect-pairwise}
\alias{allen-relation-detect-pairwise}
\alias{iv_pairwise_relates}
\title{Pairwise detect relations from Allen's Interval Algebra}
\usage{
iv_pairwise_relates(x, y, ..., type)
}
\arguments{
\item{x, y}{\verb{[iv]}

A pair of interval vectors.

These will be recycled against each other and cast to the same type.}

\item{...}{These dots are for future extensions and must be empty.}

\item{type}{\verb{[character(1)]}

The type of relationship to find. See the Allen's Interval Algebra section
for a complete description of each type. One of:
\itemize{
\item \code{"precedes"}
\item \code{"preceded-by"}
\item \code{"meets"}
\item \code{"met-by"}
\item \code{"overlaps"}
\item \code{"overlapped-by"}
\item \code{"starts"}
\item \code{"started-by"}
\item \code{"during"}
\item \code{"contains"}
\item \code{"finishes"}
\item \code{"finished-by"}
\item \code{"equals"}
}}
}
\value{
A logical vector the same size as the common size of \code{x} and \code{y}.
}
\description{
\code{iv_pairwise_relates()} is similar to
\code{\link[=iv_pairwise_overlaps]{iv_pairwise_overlaps()}}, but it detects a specific set of relations
developed by James Allen in the paper: \href{http://cse.unl.edu/~choueiry/Documents/Allen-CACM1983.pdf}{Maintaining Knowledge about Temporal Intervals}.
}
\section{Allen's Interval Algebra}{


The interval algebra developed by James Allen serves as a basis and
inspiration for \code{\link[=iv_locate_overlaps]{iv_locate_overlaps()}}, \code{\link[=iv_locate_precedes]{iv_locate_precedes()}}, and
\code{\link[=iv_locate_follows]{iv_locate_follows()}}. The original algebra is composed of 13 relations
which have the following properties:
\itemize{
\item Distinct: No pair of intervals can be related by more than one \code{type}.
\item Exhaustive: All pairs of intervals are described by one of the \code{type}s.
\item Qualitative: No numeric intervals are considered. The relationships are
computed by purely qualitative means.
}

Take the notation that \code{x} and \code{y} represent two intervals. Now assume that
\code{x} can be represented as \verb{[x_s, x_e)}, where \code{x_s} is the start of the
interval and \code{x_e} is the end of it. Additionally, assume that \code{x_s < x_e}.
With this notation, the 13 relations are as follows:
\itemize{
\item \emph{Precedes}:

\code{x_e < y_s}
\item \emph{Preceded-by}:

\code{x_s > y_e}
\item \emph{Meets}:

\code{x_e == y_s}
\item \emph{Met-by}:

\code{x_s == y_e}
\item \emph{Overlaps}:

\code{(x_s < y_s) & (x_e > y_s) & (x_e < y_e)}
\item \emph{Overlapped-by}:

\code{(x_e > y_e) & (x_s < y_e) & (x_s > y_s)}
\item \emph{Starts}:

\code{(x_s == y_s) & (x_e < y_e)}
\item \emph{Started-by}:

\code{(x_s == y_s) & (x_e > y_e)}
\item \emph{Finishes}:

\code{(x_s > y_s) & (x_e == y_e)}
\item \emph{Finished-by}:

\code{(x_s < y_s) & (x_e == y_e)}
\item \emph{During}:

\code{(x_s > y_s) & (x_e < y_e)}
\item \emph{Contains}:

\code{(x_s < y_s) & (x_e > y_e)}
\item \emph{Equals}:

\code{(x_s == y_s) & (x_e == y_e)}
}

Note that when \code{missing = "equals"}, missing intervals will only match
the \code{type = "equals"} relation. This ensures that the distinct property
of the algebra is maintained.
\subsection{Connection to other functions}{

Note that some of the above relations are fairly restrictive. For example,
\code{"overlaps"} only detects cases where \code{x} straddles \code{y_s}. It does not
consider the case where \code{x} and \code{y} are equal to be an overlap (as this
is \code{"equals"}) nor does it consider when \code{x} straddles \code{y_e} to be an
overlap (as this is \code{"overlapped-by"}). This makes the relations extremely
useful from a theoretical perspective, because they can be combined without
fear of duplicating relations, but they don't match our typical expectations
for what an "overlap" is.

\code{\link[=iv_locate_overlaps]{iv_locate_overlaps()}}, \code{\link[=iv_locate_precedes]{iv_locate_precedes()}}, and \code{\link[=iv_locate_follows]{iv_locate_follows()}} use
more intuitive \code{type}s that aren't distinct, but typically match your
expectations better. They can each be expressed in terms of Allen's
relations:
\itemize{
\item \code{iv_locate_overlaps()}:
\itemize{
\item \code{"any"}:

\code{overlaps | overlapped-by | starts | started-by | finishes | finished-by | during | contains | equals}
\item \code{"contains"}:

\code{contains | started-by | finished-by | equals}
\item \code{"within"}:

\code{during | starts | finishes | equals}
\item \code{"starts"}:

\code{starts | started-by | equals}
\item \code{"ends"}:

\code{finishes | finished-by | equals}
\item \code{"equals"}:

\code{equals}
}
\item \code{iv_locate_precedes()}:

\code{precedes | meets}
\item \code{iv_locate_follows()}:

\code{preceded-by | met-by}
}
}
}

\examples{
x <- iv_pairs(c(1, 3), c(3, 5))
y <- iv_pairs(c(3, 4), c(6, 7))

# `"precedes"` is strict, and doesn't let the endpoints match
iv_pairwise_relates(x, y, type = "precedes")

# Since that is what `"meets"` represents
iv_pairwise_relates(x, y, type = "meets")

# `"during"` only matches when `x` is completely contained in `y`, and
# doesn't allow any endpoints to match
x <- iv_pairs(c(1, 3), c(4, 5), c(8, 9))
y <- iv_pairs(c(1, 4), c(3, 8), c(8, 9))

iv_pairwise_relates(x, y, type = "during")
}
\seealso{
\link[=relation-locate]{Locating relationships}

\link[=allen-relation-locate]{Locating relations from Allen's Interval Algebra}

\link[=allen-relation-detect]{Detecting relations from Allen's Interval Algebra}
}
