% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{vcov.ivx}
\alias{vcov.ivx}
\alias{vcov.summary.ivx}
\title{Calculate Variance-Covariance Matrix for a Fitted Model Object}
\usage{
\method{vcov}{ivx}(object, complete = TRUE, ...)

\method{vcov}{summary.ivx}(object, complete = TRUE, ...)
}
\arguments{
\item{object}{a fitted ivx and summary.ivx object.}

\item{complete}{logical indicating if the full variance-covariance matrix
should be returned. When complete = TRUE, vcov() is compatible with coef().}

\item{...}{additional arguments for method functions.}
}
\value{
A matrix of the estimated covariances between the parameter estimates
of the model. This should have row and column names corresponding to the
parameter names given by the coef method.
}
\description{
Calculate Variance-Covariance Matrix for a Fitted Model Object
}
\examples{
mod <- ivx(Ret ~ LTY, data = monthly)

vcov(mod)
}
