% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jackknife.cor.R
\name{jackknife.cor}
\alias{jackknife.cor}
\title{Delete-d Jackknife Estimate for Correlation between Two Variables}
\usage{
jackknife.cor(data, d = 1, conf = 0.95, numCores = parallel::detectCores())
}
\arguments{
\item{data}{A data frame with two numeric columns.}

\item{d}{Number of observations to delete (default: 1).}

\item{conf}{Confidence level (default: 0.95).}

\item{numCores}{Number of processors (default: \code{detectCores()}).}
}
\value{
A list of class "jackknife" containing estimates, bias, standard error, and confidence intervals.
}
\description{
This function creates jackknife samples from the data by sequentially removing \emph{d} observations, calculates the correlation, and estimates bias, standard error, and confidence intervals.
}
\examples{
j.cor <- jackknife.cor(cars, d = 2, numCores = 2)
summary(j.cor)
}
\references{
Quenouille (1956), Tukey (1958), Shi (1988).
}
\seealso{
\code{\link[=cor]{cor()}}, \code{\link[=jackknife]{jackknife()}}
}
