% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-plots.r
\name{plotPolygonDensity}
\alias{plotPolygonDensity}
\title{Plot distribution and histogram overlay}
\usage{
plotPolygonDensity(
  x,
  doHistogram = TRUE,
  doPolygon = TRUE,
  col = NULL,
  barCol = "#00337799",
  polyCol = "#00449977",
  polyBorder = makeColorDarker(polyCol),
  histBorder = makeColorDarker(barCol, darkFactor = 1.5),
  colAlphas = c(0.8, 0.6, 0.9),
  darkFactors = c(-1.3, 1, 3),
  lwd = 2,
  las = 2,
  u5.bias = 0,
  pretty.n = 10,
  bw = NULL,
  breaks = 100,
  width = NULL,
  densityBreaksFactor = 3,
  axisFunc = graphics::axis,
  bty = "l",
  cex.axis = 1.5,
  doPar = TRUE,
  heightFactor = 0.95,
  weightFactor = NULL,
  main = "Histogram distribution",
  xaxs = "i",
  yaxs = "i",
  xaxt = "s",
  yaxt = "s",
  xlab = "",
  ylab = "",
  log = NULL,
  xScale = c("default", "log10", "sqrt"),
  usePanels = TRUE,
  useOnePanel = FALSE,
  ablineV = NULL,
  ablineH = NULL,
  ablineVcol = "#44444499",
  ablineHcol = "#44444499",
  ablineVlty = "solid",
  ablineHlty = "solid",
  removeNA = TRUE,
  add = FALSE,
  ylimQuantile = 0.99,
  ylim = NULL,
  xlim = NULL,
  highlightPoints = NULL,
  highlightCol = "gold",
  verbose = FALSE,
  ...
)
}
\arguments{
\item{x}{\code{numeric} vector, or \code{numeric} matrix. When a matrix is
provided, each column in the matrix is used as its own data source.}

\item{doHistogram}{\code{logical} indicating whether to plot histogram bars.}

\item{doPolygon}{\code{logical} indicating whether to plot the density polygon.}

\item{col}{\code{character} color, or when \code{x} is supplied as a matrix,
a vector of colors is applied to across plot panels.
Note that \code{col} will override all colors defined for \code{barCol}, \code{polyCol},
\code{histBorder}, \code{polyBorder}.}

\item{barCol, polyCol, polyBorder, histBorder}{\code{character} colors used
when \code{col} is not supplied.
They define colors for the histogram bars, polygon fill,
polygon border, and histogram bar border, respectively.}

\item{colAlphas}{\code{numeric} vector with length 3, indicating the alpha
transparency to use for histogram bar fill, polygon density fill,
and border color, respectively.
Alpha transparency should be scaled between 0 (fully transparent)
and 1 (fully opaque).
These alpha transparency values are applied to each color in \code{col}
when \code{col} is defined.}

\item{darkFactors}{\code{numeric} used to adjust colors when \code{col} is defined.
Values are applied to histogram bar fill, polygon density fill,
and border color, respectively, by calling \code{makeColorDarker()}.}

\item{lwd}{\code{numeric} line width.}

\item{las}{\code{integer} used to define axis label orientation.}

\item{u5.bias, pretty.n}{\code{numeric} arguments passed to to \code{base::pretty()}
to define pretty axis label positions.}

\item{bw}{\code{character} string of the bandwidth name to use in the
density calculation, passed to \code{jamba::breakDensity()}.
By default \code{stats::density()} calls a very smooth density kernel,
which obscures finer details, so the default in
\code{jamba::breakDensity()} uses a more detailed kernel.}

\item{breaks}{\code{numeric} breaks sent to \code{hist} to define the number of
histogram bars. It can be in the form of a single \code{integer} number
of equidistant breaks, or a \code{numeric} vector with specific break
positions, but remember to include a starting value lower the the
lowest value in \code{x}, and an ending value higher than the highest
value in \code{x}. Passed to \code{breakDensity()}.}

\item{width}{\code{numeric} passed to \code{breakDensity()}.}

\item{densityBreaksFactor}{\code{numeric} scaling factor to control
the level of detail in the density, passed to \code{breakDensity()}.}

\item{axisFunc}{\code{function} optionally used in place of \code{graphics::axis()} to define
axis labels.}

\item{bty}{\code{character} string used to define the plot box shape,
see \code{graphics::box()}.}

\item{cex.axis}{\code{numeric} scalar to adjust axis label font size.}

\item{doPar}{\code{logical} indicating whether to apply \code{graphics::par()}, specifically
when \code{x} is supplied as a multi-column matrix. When \code{doPar=FALSE},
no panels nor margin adjustments are made at all.}

\item{heightFactor}{\code{numeric} value indicating the height of the y-axis
plot scale to use when scaling the histogram and polygon density
within each plot panel.}

\item{weightFactor}{\code{numeric} passed to \code{breakDensity()}.}

\item{main}{\code{character} title to display above the plot, used only when
\code{x} is supplied as a single \code{numeric} vector. Otherwise each plot
title uses the relevant \code{colnames(x)} value.}

\item{xaxs, yaxs, xaxt, yaxt}{\code{character} string indicating the type of
x-axis and y-axis to render, see \code{graphics::par()}.}

\item{xlab, ylab}{\code{character} labels for x-axis and y-axis, respectively.}

\item{log}{\code{character} vector, optionally containing \code{"x"} and/or \code{"y"} to
to indicate which axes are log-transformed. If \code{"x" \%in\% log}
then it sets \code{xScale="log10"}, both methods are equivalent in
defining the log-transformation of the x-axis.}

\item{xScale}{\code{character} string to define the x-axis transformation:
\itemize{
\item \code{"default"} applies no transform;
\item \code{"log10"} applies a log10 transform, specifically \code{log10(x + 1)}
\item \code{"sqrt"} applies a sqrt transform.
}}

\item{usePanels}{\code{logical} indicating whether to separate
the density plots into panels when \code{x} contains multiple columns.
When \code{useOnePanel=FALSE} the panels will be defined so that all
columns will fit on one page.}

\item{useOnePanel}{\code{logical} indicating whether to define multiple panels
on one page. Therefore \code{useOnePanel=TRUE} will create multiple
pages with one panel on each page, which may work well for
output in multi-page 'PDF' files.}

\item{ablineV, ablineH}{\code{numeric} vector representing abline
vertical and horizontal positions, respectively.
These values are mostly helpful in multi-panel plots,
to draw consistent reference lines on each panel.}

\item{ablineVcol, ablineHcol, }{default"#44444499", with the abline
color, used when \code{ablineV} or \code{ablineH} are supplied, respectively.}

\item{ablineVlty, ablineHlty}{\code{numeric} or \code{character} indicating the
line type to use for \code{ablineV} and \code{ablineH}, respectively.}

\item{removeNA}{\code{logical} indicating whether to remove NA values
prior to running histogram and density calculations. Presence
of NA values generally causes both functions to fail.}

\item{add}{\code{logical} indicating whether to add the plot to an existing
visualization.}

\item{ylimQuantile}{\code{numeric} value between 0 and 1, indicating the
quantile value of the density \code{y} values to use for the ylim. This
threshold is only applied when \code{ylim} is NULL.}

\item{ylim, xlim}{\code{numeric} y-axis and x-axis ranges, respectively.
When either is \code{NULL}, the axis range is determined independently
for each plot panel. Either value can be supplied as a \code{list}
to control the numeric range for each individual plot, relevant
only when \code{x} is supplied as a multi-column matrix.}

\item{highlightPoints}{\code{character} vector of optional rownames,
or \code{integer} values with row indices, for rows to be highlighted.
When \code{x} is supplied as a \code{matrix}, \code{highlightPoints} can
be supplied as a \code{list} of vectors, referring to each column in \code{x}.
When rows are highlighted, the plot is drawn with all points,
then the highlighted points are drawn again over the histogram bars,
and polygon density, as relevant.}

\item{highlightCol}{\code{character} vector of colors to
use to fill the histogram when \code{highlightPoints} is supplied.
Multiple values are recycled one per column in \code{x},
if \code{x} is supplied as a multi-column matrix.}

\item{verbose}{\code{logical} indicating whether to print verbose output.}

\item{...}{additional arguments are passed to relevant internal
functions.}
}
\value{
invisible \code{list} with density and histogram data output,
however this function is called for the by-product of its plot
output.
}
\description{
Plot distribution and histogram overlay
}
\details{
This function is a wrapper around \code{graphics::hist()} and
\code{stats::density()}, with enough customization to cover
most of the situations that need customization.

For example \code{log="x"} will automatically log-transform the x-axis,
keeping the histogram bars uniformly sized. Alternatively,
\code{xScale="sqrt"} will square root transform the data, and
transform the x-axis while keeping the numeric values constant.

It also scales the density profile height to be similar to
the histogram bar height, using the 99th quantile of the y-axis
value, which helps prevent outlier peaks from dominating the
y-axis range, thus obscuring interesting smaller features.

If supplied with a data matrix, this function will create a layout
with \code{ncol(x)} panels, and plot the distribution of each column
in its own panel, using categorical colors from \code{rainbow2()}.

For a similar style using ggplot2, see \code{plotRidges()}, which displays
only the density profile for each sample, but in a much more scalable
format for larger numbers of columns.

By default NA values are ignored, and the distributions represent
non-NA values.

Colors can be controlled using the parameter \code{col}, but can
be specifically defined for bars with \code{barCol} and the polygon
with \code{polyCol}.
}
\examples{
# basic density plot
set.seed(123);
x <- stats::rnorm(2000);
plotPolygonDensity(x, main="basic polygon density plot");

# fewer breaks
plotPolygonDensity(x,
   breaks=20,
   main="breaks=20");

# log-scaled x-axis
plotPolygonDensity(10^(3+stats::rnorm(2000)), log="x",
   breaks=50,
   main="log-scaled x-axis");

# highlighted points
set.seed(123);
plotPolygonDensity(x,
   highlightPoints=sample(which(abs(x) > 1), size=200),
   breaks=40,
   main="breaks=40");

# hide axis labels
set.seed(123);
plotPolygonDensity(x,
   highlightPoints=sample(which(abs(x) > 1), size=200),
   breaks=40,
   xaxt="n",
   yaxt="n",
   main="breaks=40");

# multiple columns
set.seed(123);
xm <- do.call(cbind, lapply(1:4, function(i){stats::rnorm(2000)}))
plotPolygonDensity(xm, breaks=20)

}
\seealso{
Other jam plot functions: 
\code{\link{adjustAxisLabelMargins}()},
\code{\link{coordPresets}()},
\code{\link{decideMfrow}()},
\code{\link{drawLabels}()},
\code{\link{getPlotAspect}()},
\code{\link{groupedAxis}()},
\code{\link{imageByColors}()},
\code{\link{imageDefault}()},
\code{\link{minorLogTicksAxis}()},
\code{\link{nullPlot}()},
\code{\link{plotRidges}()},
\code{\link{plotSmoothScatter}()},
\code{\link{shadowText}()},
\code{\link{shadowText_options}()},
\code{\link{showColors}()},
\code{\link{sqrtAxis}()},
\code{\link{usrBox}()}
}
\concept{jam plot functions}
