% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_Exp.R
\name{Exp}
\alias{Exp}
\alias{d,Exp,numeric-method}
\alias{p,Exp,numeric-method}
\alias{qn,Exp,numeric-method}
\alias{r,Exp,numeric-method}
\alias{mean,Exp-method}
\alias{median,Exp-method}
\alias{mode,Exp-method}
\alias{var,Exp-method}
\alias{sd,Exp-method}
\alias{skew,Exp-method}
\alias{kurt,Exp-method}
\alias{entro,Exp-method}
\alias{finf,Exp-method}
\alias{llexp}
\alias{ll,Exp,numeric-method}
\alias{eexp}
\alias{mle,Exp,numeric-method}
\alias{me,Exp,numeric-method}
\alias{vexp}
\alias{avar_mle,Exp-method}
\alias{avar_me,Exp-method}
\title{Exponential Distribution}
\usage{
Exp(rate = 1)

\S4method{d}{Exp,numeric}(distr, x, log = FALSE)

\S4method{p}{Exp,numeric}(distr, q, lower.tail = TRUE, log.p = FALSE)

\S4method{qn}{Exp,numeric}(distr, p, lower.tail = TRUE, log.p = FALSE)

\S4method{r}{Exp,numeric}(distr, n)

\S4method{mean}{Exp}(x)

\S4method{median}{Exp}(x)

\S4method{mode}{Exp}(x)

\S4method{var}{Exp}(x)

\S4method{sd}{Exp}(x)

\S4method{skew}{Exp}(x)

\S4method{kurt}{Exp}(x)

\S4method{entro}{Exp}(x)

\S4method{finf}{Exp}(x)

llexp(x, rate)

\S4method{ll}{Exp,numeric}(distr, x)

eexp(x, type = "mle", ...)

\S4method{mle}{Exp,numeric}(distr, x, na.rm = FALSE)

\S4method{me}{Exp,numeric}(distr, x, na.rm = FALSE)

vexp(rate, type = "mle")

\S4method{avar_mle}{Exp}(distr)

\S4method{avar_me}{Exp}(distr)
}
\arguments{
\item{rate}{numeric. The distribution parameter.}

\item{distr}{an object of class \code{Exp}.}

\item{x}{For the density function, \code{x} is a numeric vector of quantiles. For
the moments functions, \code{x} is an object of class \code{Exp}. For the
log-likelihood and the estimation functions, \code{x} is the sample of
observations.}

\item{log, log.p}{logical. Should the logarithm of the probability be
returned?}

\item{q}{numeric. Vector of quantiles.}

\item{lower.tail}{logical. If TRUE (default), probabilities are
\eqn{P(X \leq x)}, otherwise \eqn{P(X > x)}.}

\item{p}{numeric. Vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken to
be the number required.}

\item{type}{character, case ignored. The estimator type (mle or me).}

\item{...}{extra arguments.}

\item{na.rm}{logical. Should the \code{NA} values be removed?}
}
\value{
Each type of function returns a different type of object:
\itemize{
\item Distribution Functions: When supplied with one argument (\code{distr}), the
\code{d()}, \code{p()}, \code{q()}, \code{r()}, \code{ll()} functions return the density, cumulative
probability, quantile, random sample generator, and log-likelihood functions,
respectively. When supplied with both arguments (\code{distr} and \code{x}), they
evaluate the aforementioned functions directly.
\item Moments: Returns a numeric, either vector or matrix depending on the moment
and the distribution. The \code{moments()} function returns a list with all the
available methods.
\item Estimation: Returns a list, the estimators of the unknown parameters. Note
that in distribution families like the binomial, multinomial, and negative
binomial, the size is not returned, since it is considered known.
\item Variance: Returns a named matrix. The asymptotic covariance matrix of the
estimator.
}
}
\description{
The Exponential distribution is a continuous probability distribution often
used to model the time between independent events that occur at a constant
average rate. It is defined by the rate parameter \eqn{\lambda > 0}.
}
\details{
The probability density function (PDF) of the Exponential distribution is
given by: \deqn{ f(x; \lambda) = \lambda e^{-\lambda x}, \quad x \geq 0 .}
}
\examples{
# -----------------------------------------------------
# Exp Distribution Example
# -----------------------------------------------------

# Create the distribution
rate <- 5
D <- Exp(rate)

# ------------------
# dpqr Functions
# ------------------

d(D, c(0.3, 2, 10)) # density function
p(D, c(0.3, 2, 10)) # distribution function
qn(D, c(0.4, 0.8)) # inverse distribution function
x <- r(D, 100) # random generator function

# alternative way to use the function
df <- d(D) ; df(x) # df is a function itself

# ------------------
# Moments
# ------------------

mean(D) # Expectation
median(D) # Median
mode(D) # Mode
var(D) # Variance
sd(D) # Standard Deviation
skew(D) # Skewness
kurt(D) # Excess Kurtosis
entro(D) # Entropy
finf(D) # Fisher Information Matrix

# List of all available moments
mom <- moments(D)
mom$mean # expectation

# ------------------
# Point Estimation
# ------------------

ll(D, x)
llexp(x, rate)

eexp(x, type = "mle")
eexp(x, type = "me")

mle(D, x)
me(D, x)
e(D, x, type = "mle")

mle("exp", x) # the distr argument can be a character

# ------------------
# Estimator Variance
# ------------------

vexp(rate, type = "mle")
vexp(rate, type = "me")

avar_mle(D)
avar_me(D)

v(D, type = "mle")
}
\seealso{
Functions from the \code{stats} package: \code{\link[=dexp]{dexp()}}, \code{\link[=pexp]{pexp()}}, \code{\link[=qexp]{qexp()}}, \code{\link[=rexp]{rexp()}}
}
