% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_generics.R
\name{estimation}
\alias{estimation}
\alias{e}
\alias{mle}
\alias{me}
\alias{same}
\alias{mle,character,ANY-method}
\alias{me,character,ANY-method}
\alias{same,character,ANY-method}
\title{Parameter Estimation}
\usage{
e(distr, x, type = "mle", ...)

mle(distr, x, ...)

\S4method{mle}{character,ANY}(distr, x, ...)

me(distr, x, ...)

\S4method{me}{character,ANY}(distr, x, ...)

same(distr, x, ...)

\S4method{same}{character,ANY}(distr, x, ...)
}
\arguments{
\item{distr}{A \code{Distribution} object or a \code{character}. The distribution
family assumed.}

\item{x}{numeric. A sample under estimation.}

\item{type}{character, case ignored. The estimator type.}

\item{...}{extra arguments.}
}
\value{
list. The estimator of the unknown parameters. Note that in
distribution families like the binomial, multinomial, and negative binomial,
the size is not returned, since it is considered known.
}
\description{
This set of functions estimates the parameters of a random sample according
to a specified family of distributions. See details.
}
\details{
The package covers three major estimation methods: maximum likelihood
estimation (MLE), moment estimation (ME), and score-adjusted estimation
(SAME).

In order to perform parameter estimation, a new \verb{e<name>()} member is added
to the \code{d()}, \code{p()}, \code{q()}, \code{r()} family, following the standard \code{stats} name
convention. These functions take two arguments, the observations \code{x} (an
atomic vector for univariate or a matrix for multivariate distributions) and
the \code{type} of estimation method to use (a character with possible values
\code{"mle"}, \code{"me"}, and \code{"same"}.)

Point estimation functions are available in two versions, the distribution
specific one, e.g. \code{ebeta()}, and the S4 generic ones, namely \code{mle()},
\code{me()}, and \code{same()}. A general function called \code{e()} is also implemented,
covering all distributions and estimators.
}
\section{Functions}{
\itemize{
\item \code{mle()}: Maximum Likelihood Estimator

\item \code{me()}: Moment Estimator

\item \code{same()}: Score - Adjusted Moment Estimation

}}
\examples{
# -----------------------------------------------------
# Beta Distribution Example
# -----------------------------------------------------

# Create the distribution
a <- 3
b <- 5
D <- Beta(a, b)

# ------------------
# dpqr Functions
# ------------------

d(D, c(0.3, 0.8, 0.5)) # density function
p(D, c(0.3, 0.8, 0.5)) # distribution function
qn(D, c(0.4, 0.8)) # inverse distribution function
x <- r(D, 100) # random generator function

# alternative way to use the function
df <- d(D) ; df(x) # df is a function itself

# ------------------
# Moments
# ------------------

mean(D) # Expectation
var(D) # Variance
sd(D) # Standard Deviation
skew(D) # Skewness
kurt(D) # Excess Kurtosis
entro(D) # Entropy
finf(D) # Fisher Information Matrix

# List of all available moments
mom <- moments(D)
mom$mean # expectation

# ------------------
# Point Estimation
# ------------------

ll(D, x)
llbeta(x, a, b)

ebeta(x, type = "mle")
ebeta(x, type = "me")
ebeta(x, type = "same")

mle(D, x)
me(D, x)
same(D, x)
e(D, x, type = "mle")

mle("beta", x) # the distr argument can be a character

# ------------------
# Estimator Variance
# ------------------

vbeta(a, b, type = "mle")
vbeta(a, b, type = "me")
vbeta(a, b, type = "same")

avar_mle(D)
avar_me(D)
avar_same(D)

v(D, type = "mle")
}
\references{
General Textbooks
\itemize{
\item Van der Vaart, A. W. (2000), Asymptotic statistics, Vol. 3,
Cambridge university press.
}

Beta and gamma distribution families
\itemize{
\item Ye, Z.-S. & Chen, N. (2017), Closed-form estimators for the gamma
distribution derived from likelihood equations, The American Statistician
71(2), 177–181.
\item Tamae, H., Irie, K. & Kubokawa, T. (2020), A score-adjusted approach to
closed-form estimators for the gamma and beta distributions, Japanese Journal
of Statistics and Data Science 3, 543–561.
\item Mathal, A. & Moschopoulos, P. (1992), A form of multivariate gamma
distribution, Annals of the Institute of Statistical Mathematics 44, 97–106.
\item Oikonomidis, I. & Trevezas, S. (2023), Moment-Type Estimators for the
Dirichlet and the Multivariate Gamma Distributions, arXiv,
https://arxiv.org/abs/2311.15025
}
}
\seealso{
\link{mle}, \link{me}, \link{same}
}
