% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_generics.R
\name{variance}
\alias{variance}
\alias{v}
\alias{avar_mle}
\alias{avar_me}
\alias{avar_same}
\title{Estimator Variance}
\usage{
v(distr, type, ...)

avar_mle(distr, ...)

avar_me(distr, ...)

avar_same(distr, ...)
}
\arguments{
\item{distr}{A \code{Distribution} object.}

\item{type}{character, case ignored. The estimator type.}

\item{...}{extra arguments.}
}
\value{
numeric, or matrix for multidimensional cases.
}
\description{
These functions calculate the variance (or variance - covariance matrix in
the multidimensional case) of an estimator, given a specified family of
distributions and the true parameter values.
}
\section{Functions}{
\itemize{
\item \code{avar_mle()}: Asymptotic Variance of the Maximum Likelihood Estimator

\item \code{avar_me()}: Asymptotic Variance of the Moment Estimator

\item \code{avar_same()}: Asymptotic Variance of the Score-Adjusted Moment
Estimator

}}
\examples{
# -----------------------------------------------------
# Beta Distribution Example
# -----------------------------------------------------

# Create the distribution
a <- 3
b <- 5
D <- Beta(a, b)

# ------------------
# dpqr Functions
# ------------------

d(D, c(0.3, 0.8, 0.5)) # density function
p(D, c(0.3, 0.8, 0.5)) # distribution function
qn(D, c(0.4, 0.8)) # inverse distribution function
x <- r(D, 100) # random generator function

# alternative way to use the function
df <- d(D) ; df(x) # df is a function itself

# ------------------
# Moments
# ------------------

mean(D) # Expectation
var(D) # Variance
sd(D) # Standard Deviation
skew(D) # Skewness
kurt(D) # Excess Kurtosis
entro(D) # Entropy
finf(D) # Fisher Information Matrix

# List of all available moments
mom <- moments(D)
mom$mean # expectation

# ------------------
# Point Estimation
# ------------------

ll(D, x)
llbeta(x, a, b)

ebeta(x, type = "mle")
ebeta(x, type = "me")
ebeta(x, type = "same")

mle(D, x)
me(D, x)
same(D, x)
e(D, x, type = "mle")

mle("beta", x) # the distr argument can be a character

# ------------------
# Estimator Variance
# ------------------

vbeta(a, b, type = "mle")
vbeta(a, b, type = "me")
vbeta(a, b, type = "same")

avar_mle(D)
avar_me(D)
avar_same(D)

v(D, type = "mle")
}
\references{
General Textbooks
\itemize{
\item Van der Vaart, A. W. (2000), Asymptotic statistics, Vol. 3,
Cambridge university press.
}

Beta and gamma distribution families
\itemize{
\item Ye, Z.-S. & Chen, N. (2017), Closed-form estimators for the gamma
distribution derived from likelihood equations, The American Statistician
71(2), 177–181.
\item Tamae, H., Irie, K. & Kubokawa, T. (2020), A score-adjusted approach to
closed-form estimators for the gamma and beta distributions, Japanese Journal
of Statistics and Data Science 3, 543–561.
\item Mathal, A. & Moschopoulos, P. (1992), A form of multivariate gamma
distribution, Annals of the Institute of Statistical Mathematics 44, 97–106.
\item Oikonomidis, I. & Trevezas, S. (2023), Moment-Type Estimators for the
Dirichlet and the Multivariate Gamma Distributions, arXiv,
https://arxiv.org/abs/2311.15025
}
}
\seealso{
\link{avar_mle}, \link{avar_me}, \link{avar_same}
}
