% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-joins.R
\name{arguments_checks}
\alias{arguments_checks}
\title{Perform necessary preliminary checks on arguments that are passed to joyn}
\usage{
arguments_checks(
  x,
  y,
  by,
  copy,
  keep,
  suffix,
  na_matches,
  multiple,
  relationship,
  reportvar
)
}
\arguments{
\item{x}{data frame: left table}

\item{y}{data frame: right table}

\item{by}{character vector or variables to join by}

\item{copy}{If \code{x} and \code{y} are not from the same data source,
and \code{copy} is \code{TRUE}, then \code{y} will be copied into the
same src as \code{x}.  This allows you to join tables across srcs, but
it is a potentially expensive operation so you must opt into it.}

\item{keep}{Should the join keys from both \code{x} and \code{y} be preserved in the
output?
\itemize{
\item If \code{NULL}, the default, joins on equality retain only the keys from \code{x},
while joins on inequality retain the keys from both inputs.
\item If \code{TRUE}, all keys from both inputs are retained.
\item If \code{FALSE}, only keys from \code{x} are retained. For right and full joins,
the data in key columns corresponding to rows that only exist in \code{y} are
merged into the key columns from \code{x}. Can't be used when joining on
inequality conditions.
}}

\item{suffix}{If there are non-joined duplicate variables in \code{x} and
\code{y}, these suffixes will be added to the output to disambiguate them.
Should be a character vector of length 2.}

\item{na_matches}{Should two \code{NA} or two \code{NaN} values match?
\itemize{
\item \code{"na"}, the default, treats two \code{NA} or two \code{NaN} values as equal, like
\code{\%in\%}, \code{\link[=match]{match()}}, and \code{\link[=merge]{merge()}}.
\item \code{"never"} treats two \code{NA} or two \code{NaN} values as different, and will
never match them together or to any other values. This is similar to joins
for database sources and to \code{base::merge(incomparables = NA)}.
}}

\item{multiple}{Handling of rows in \code{x} with multiple matches in \code{y}.
For each row of \code{x}:
\itemize{
\item \code{"all"}, the default, returns every match detected in \code{y}. This is the
same behavior as SQL.
\item \code{"any"} returns one match detected in \code{y}, with no guarantees on which
match will be returned. It is often faster than \code{"first"} and \code{"last"}
if you just need to detect if there is at least one match.
\item \code{"first"} returns the first match detected in \code{y}.
\item \code{"last"} returns the last match detected in \code{y}.
}}

\item{relationship}{Handling of the expected relationship between the keys of
\code{x} and \code{y}. If the expectations chosen from the list below are
invalidated, an error is thrown.
\itemize{
\item \code{NULL}, the default, doesn't expect there to be any relationship between
\code{x} and \code{y}. However, for equality joins it will check for a many-to-many
relationship (which is typically unexpected) and will warn if one occurs,
encouraging you to either take a closer look at your inputs or make this
relationship explicit by specifying \code{"many-to-many"}.

See the \emph{Many-to-many relationships} section for more details.
\item \code{"one-to-one"} expects:
\itemize{
\item Each row in \code{x} matches at most 1 row in \code{y}.
\item Each row in \code{y} matches at most 1 row in \code{x}.
}
\item \code{"one-to-many"} expects:
\itemize{
\item Each row in \code{y} matches at most 1 row in \code{x}.
}
\item \code{"many-to-one"} expects:
\itemize{
\item Each row in \code{x} matches at most 1 row in \code{y}.
}
\item \code{"many-to-many"} doesn't perform any relationship checks, but is provided
to allow you to be explicit about this relationship if you know it
exists.
}

\code{relationship} doesn't handle cases where there are zero matches. For that,
see \code{unmatched}.}

\item{reportvar}{character: Name of reporting variable. Default is ".joyn".
This is the same as variable "_merge" in Stata after performing a merge. If
FALSE or NULL, the reporting variable will be excluded from the final
table, though a summary of the join will be display after concluding.}
}
\value{
list of checked arguments to pass on to the main joyn function
}
\description{
Perform necessary preliminary checks on arguments that are passed to joyn
}
\keyword{internal}
