% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataManager.R
\name{DataManager}
\alias{DataManager}
\title{DataManager R6 Class for Shiny Modules}
\description{
An R6 class to manage data loading, preprocessing, and common UI elements
for various Shiny modules in the package. It handles file reading (csv, xlsx,
sav, sas7bdat, dta), initial variable analysis, and the rendering and logic for
common data manipulations like creating binary variables, changing factor
references, and subsetting data. This class is designed to be used internally
by other Shiny server modules to reduce code duplication.
}
\keyword{internal}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{input}}{Shiny module's input object.}

\item{\code{output}}{Shiny module's output object.}

\item{\code{session}}{Shiny module's session object.}

\item{\code{ns}}{Shiny module's namespace function.}

\item{\code{nfactor.limit}}{The threshold for unique values to suggest a numeric
variable as a factor.}

\item{\code{initial_data_info}}{A reactive value holding the initially loaded
data and its metadata.}

\item{\code{processed_data}}{A reactive value holding the data after all
transformations have been applied.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DataManager-new}{\code{DataManager$new()}}
\item \href{#method-DataManager-get_reactive_data}{\code{DataManager$get_reactive_data()}}
\item \href{#method-DataManager-clone}{\code{DataManager$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataManager-new"></a>}}
\if{latex}{\out{\hypertarget{method-DataManager-new}{}}}
\subsection{Method \code{new()}}{
Create a new DataManager object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataManager$new(input, output, session, nfactor.limit = 20)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Shiny module's input object.}

\item{\code{output}}{Shiny module's output object.}

\item{\code{session}}{Shiny module's session object.}

\item{\code{nfactor.limit}}{The maximum number of unique values for a continuous
variable to be suggested as a factor.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `DataManager` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataManager-get_reactive_data"></a>}}
\if{latex}{\out{\hypertarget{method-DataManager-get_reactive_data}{}}}
\subsection{Method \code{get_reactive_data()}}{
Returns the final processed data as a reactive expression.
This is the main output to be used by the calling module.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataManager$get_reactive_data()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A reactive expression that returns a list containing the
processed `data`, `label` information, and `naomit` message.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataManager-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DataManager-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataManager$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
