% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print_all}
\alias{print_all}
\title{Print all rows of elements}
\usage{
print_all(x, ask = TRUE)
}
\arguments{
\item{x}{Object to print, typically a data frame or vector.}

\item{ask}{If the length of \code{x} exceeds \code{getOption("max.print")}, should the
user be promoted confirm their intention to print everything. If \code{FALSE},
the maximum is printed without double checking: this can be \strong{extremely}
slow. The 'usethis' package must be installed for interactive confirmation.}
}
\value{
The object x (invisibly)
}
\description{
Print up to the \code{getOption("max.print")} and ask the user if they want to
print more than that. This is most useful when printing tibbles with more
than 10 rows but less than \code{getOption("max.print")}.
}
