% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Jfunctions.R
\name{J2}
\alias{J2}
\title{J2}
\usage{
J2(u, cc = sqrt(5))
}
\arguments{
\item{u}{Numeric vector.}

\item{cc}{Numeric constant, defaults to \eqn{\sqrt 5}.}
}
\value{
Vector of same length and mode as \code{u}.
}
\description{
Eq. (20) in Eichner (2017) (based on "Bronstein's formula for k = 3")
}
\details{
\eqn{J_2(u, c) = 2\sqrt(-p_c) * sin(1/3 * arcsin(q_c(u) / (-p_c)^{3/2}))}

For implementation details of \eqn{q_c(u)} and \eqn{p_c} see
\code{\link{qc}} and \code{\link{pc}}, respectively.

For further mathematical details see Eichner (2017) and/or Eichner &
Stute (2013).
}
\note{
Eq. (20) in Eichner (2017), and hence \eqn{J_2(u, c)}, requires
      \eqn{c} to be in \eqn{(\sqrt 3, \sqrt 5]}. If \code{cc} does
      not satisfy this requirement (only) a warning is issued.

      The default \code{cc = sqrt(5)} yields the optimal rank
      transformation.
}
\examples{
\donttest{
u <- seq(0, 1, by = 0.01)
c0 <- expression(sqrt(3) + 0.01)
c1 <- expression(sqrt(5))
cgrid <- seq(1.85, 2.15, by = 0.1)
cvals <- c(eval(c0), cgrid, eval(c1))

Y <- sapply(cvals, function(cc, u) J2(u, cc = cc), u = u)
cols <- rainbow(ncol(Y), end = 9/12)
matplot(u, Y, type = "l", lty = "solid", col = cols,
  ylab = expression(J[2](u, c)))
abline(h = 0)
legend("topleft", title = "c", legend = c(c0, cgrid, c1),
  lty = 1, col = cols, cex = 0.8)
}

}
\seealso{
\code{\link{J_admissible}}.
}
