% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bias_var_mse.R
\name{kfn_vectorized}
\alias{kfn_vectorized}
\title{Convolution of Kernel Function K with fn}
\usage{
kfn_vectorized(u, K, xixj, h, sig)
}
\arguments{
\item{u}{Numeric vector.}

\item{K}{Kernel function with vectorized in- & output.}

\item{xixj}{Numeric matrix.}

\item{h}{Numeric scalar.}

\item{sig}{Numeric scalar.}
}
\value{
A vector of \eqn{(K * f_n)(u)} evaluated at the values in
        \code{u}.
}
\description{
Vectorized evaluation of the convolution of the kernel function K with fn.
}
\details{
Vectorized (in u) evaluation of - a more explicit representation of - the
integrand \eqn{K(u) * f_n(\ldots - h^2/\sigma * u)} which is used in the
computation of the bias estimator before eq. (2.3) in Srihera & Stute (2011).
Also used for the analogous computation of the respective bias estimator
in the paragraph after eq. (6) in Eichner & Stute (2013).
}
\note{
An alternative implementation could be
      \code{K(u) * sapply(h/sig * u, function(v) mean(K(xixj - v))) / h}
}
\examples{
require(stats)

set.seed(2017);   n <- 100;   Xdata <- rnorm(n)
x0 <- 1;          sig <- 1;   h <- n^(-1/5)

Ai <- (x0 - Xdata)/h
Bj <- mean(Xdata) - Xdata   # in case of non-robust method
AiBj <- outer(Ai, Bj/sig, "+")

ugrid <- seq(-10, 10, by = 1)
kader:::kfn_vectorized(u = ugrid, K = dnorm, xixj = AiBj, h = h, sig = sig)

}
