% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/bootstrap.R
\docType{methods}
\name{bootstrap.MeanDate}
\alias{bootstrap.MeanDate}
\alias{bootstrap,MeanDate-method}
\title{Bootstrap Mean Ceramic Dates}
\usage{
\S4method{bootstrap}{MeanDate}(
  object,
  n = 1000,
  f = NULL,
  level = 0.95,
  interval = c("basic", "normal", "percentiles"),
  seed = NULL,
  calendar = get_calendar()
)
}
\arguments{
\item{object}{A \code{\linkS4class{MeanDate}} object (typically returned by \code{\link[=mcd]{mcd()}}).}

\item{n}{A non-negative \code{\link{integer}} specifying the number of bootstrap
replications.}

\item{f}{A \code{\link{function}} that takes a single numeric vector (the result of
the resampling procedure) as argument.}

\item{level}{A length-one \code{\link{numeric}} vector giving the confidence level.
Must be a single number between \eqn{0} and \eqn{1}. Only used if \code{f} is
\code{NULL}.}

\item{interval}{A \code{\link{character}} string giving the type of confidence
interval to be returned. It must be one "\code{basic}" (the default), "\code{normal}"
or "\code{percentiles}" (see \code{\link[arkhe:confidence_bootstrap]{arkhe::confidence_bootstrap()}}). Any unambiguous
substring can be given. Only used if \code{f} is \code{NULL}.}

\item{seed}{An object specifying if and how the random number generator
should be initialized (see \code{\link[stats:simulate]{stats::simulate()}}).}

\item{calendar}{An \code{\link[aion:TimeScale-class]{aion::TimeScale}} object specifying the target
calendar (see \code{\link[aion:calendar]{aion::calendar()}}).}
}
\value{
If \code{f} is \code{NULL}, \code{bootstrap()} returns a \code{\link{data.frame}} with the following
elements (else, returns the result of \code{f} applied to the \code{n} resampled
values) :
\describe{
\item{\code{original}}{The observed value.}
\item{\code{mean}}{The bootstrap estimate of mean.}
\item{\code{bias}}{The bootstrap estimate of bias.}
\item{\code{error}}{The boostrap estimate of standard error.}
\item{\code{lower}}{The lower limit of the bootstrap confidence interval at \code{level}.}
\item{\code{upper}}{The upper limit of the bootstrap confidence interval at \code{level}.}
}
}
\description{
Generates bootstrap estimations of an \link[=mcd]{MCD}.
}
\examples{
## Data from Peeples and Schachner 2012
data("zuni", package = "folio")

## Set the start and end dates for each ceramic type
dates <- list(
  LINO = c(600, 875), KIAT = c(850, 950), RED = c(900, 1050),
  GALL = c(1025, 1125), ESC = c(1050, 1150), PUBW = c(1050, 1150),
  RES = c(1000, 1200), TULA = c(1175, 1300), PINE = c(1275, 1350),
  PUBR = c(1000, 1200), WING = c(1100, 1200), WIPO = c(1125, 1225),
  SJ = c(1200, 1300), LSJ = c(1250, 1300), SPR = c(1250, 1300),
  PINER = c(1275, 1325), HESH = c(1275, 1450), KWAK = c(1275, 1450)
)

## Calculate date midpoints
mid <- vapply(X = dates, FUN = mean, FUN.VALUE = numeric(1))

## Calculate MCD
(mc_dates <- mcd(zuni[100:125, ], dates = mid))

## Get MCD in years CE
time(mc_dates, calendar = CE())

## Bootstrap resampling
boot <- bootstrap(mc_dates, n = 30)
head(boot)

## Jackknife resampling
jack <- jackknife(mc_dates)
head(jack)

## Plot
plot(mc_dates, decreasing = FALSE)
## Add bootstrap confidence intervals
segments(x0 = boot$lower, y0 = seq_len(nrow(boot)),
         x1 = boot$upper, y1 = seq_len(nrow(boot)))
}
\seealso{
\code{\link[=mcd]{mcd()}}

Other resampling methods: 
\code{\link{bootstrap.EventDate}},
\code{\link{jackknife.EventDate}},
\code{\link{jackknife.MeanDate}}
}
\author{
N. Frerebeau
}
\concept{resampling methods}
