% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{lkmt.net.kernel.hsa04020}
\alias{lkmt.net.kernel.hsa04020}
\title{Example test result for the network-based \code{\link{kernel}} for 
\code{\link{pathway}} hsa04020.}
\format{
An object of class \code{\link{lkmt}} for the network-based  
\code{\link{kernel}} and the \code{\link{pathway}} hsa04020.
\describe{
 \item{formular}{gives a formular defining the nullmodel used in the 
logistic kernel machine test}
\item{kernel}{includes the \code{\link{kernel}} object of the 
\code{\link{pathway}} to be evaluated}
\item{GWASdata}{gives the \code{\link{GWASdata}} object including the study data 
considered in testing}
\item{statistic}{gives the value of the test statistic}
\item{df}{specifies the degrees of freedom}
\item{p.value}{includes teh p-value resulting from the test}
}
}
\source{
simulated data and Ensembl extract
}
\usage{
data(lkmt.net.kernel.hsa04020)
}
\description{
An object of class \code{\link{lkmt}} containing exemplary test results for an 
application of the logistic kernel machine test, derived from the example data.
}
\examples{
data(hsa04020)
data(gwas)
net_kernel <- calc_kernel(gwas, hsa04020, knots=NULL, type='net', calculation='cpu')
lkmt_test(pheno ~ sex + age, net_kernel, gwas, method='satt')
}
\keyword{datasets}
