% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_coefs.r
\name{lm_coefs}
\alias{lm_coefs}
\title{Linear Model Coefficients}
\usage{
lm_coefs(x, y, tol = 1e-07)
}
\arguments{
\item{x, y}{The input data \code{x} and response \code{y}.  Each must be a shaq, and
each must be distributed in an identical fashion.  See the details section
for more information.}

\item{tol}{Numerical tolerance for deciding rank.}
}
\value{
A regular vector.
}
\description{
Coefficients of the linear model.
}
\details{
The model is fit using a QR factorization of the input \code{x}. At this
time, that means 

Both of \code{x} and \code{y} must be distributed in an identical fashion.
This means that the number of rows owned by each MPI rank should match, and
the data rows \code{x} and labels \code{y} should be aligned.  Additionally,
each MPI rank should own at least one row.  Ideally they should be load
balanced, so that each MPI rank owns roughly the same amount of data.
}
\section{Communication}{

The operation has the same communication as
}

\examples{
\dontrun{
library(kazaam)
comm.set.seed(1234, diff=TRUE)

x = ranshaq(rnorm, 10, 3)
y = ranshaq(runif, 10)

fit = lm_coefs(x, y)
comm.print(fit)

finalize()
}

}
\seealso{
\code{\link{glms}}
}
