% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{biasbound}
\alias{biasbound}
\title{Worst-Case Bias Bound due to Incomplete Balance}
\usage{
biasbound(observed, target, svd.out, w, w.pop = NULL, hilbertnorm = 1)
}
\arguments{
\item{observed}{a numeric vector of length equal to the total number of units where sampled/control units take a value of 1 and population/treated units take a value of 0.}

\item{target}{a numeric vector of length equal to the total number of units where population/treated units take a value of 1 and sample/control units take a value of 0.}

\item{svd.out}{the list object output from \code{svd()} performed on the kernel matrix. Requires a list object with left singular vectors in \code{svd.out$u} and singular values in \code{svd.out$d}}

\item{w}{numeric vector containing the weight for every corresponding unit. Note that these weights should sum to the total number of units, not to one. They are divided by the number of control or sample and treated or population units internally.}

\item{w.pop}{an optional vector input to specify population weights. Must be of length equal to the total number of units (rows in \code{svd.out}) with all sampled units receiving a weight of 1. The sum of the weights for population units must be either 1 or the number of population units.}

\item{hilbertnorm}{numeric value of the Hilbert norm. Default is \code{1}.}
}
\value{
\item{biasbound}{value of worst-case bias bound due to incomplete balance with inputted weights}
}
\description{
Calculate the upper bound on the bias induced by approximate balance with a given \code{hilbertnorm}. Approximate balance is conducted in \code{kbal()} and uses only the first \code{numdims} dimensions of the singular value decomposition of the kernel matrix to generate weights \code{w} which produce mean balance between control or sampled units and treated or population units. The following function calculates the worse-case bias induced by this approximate balancing with weights \code{w} and a given \code{hilbertnorm}.
}
\examples{
\donttest{
#load and clean data a bit
set.seed(123)
data("lalonde")
# Select a random subset of 500 rows
lalonde_sample <- sample(1:nrow(lalonde), 500, replace = FALSE)
lalonde <- lalonde[lalonde_sample, ]

xvars=c("age","black","educ","hisp","married","re74","re75","nodegr","u74","u75")

#need a kernel matrix to run SVD on and pass in so get that first with makeK
#running makeK with the sampled units as the bases
K = makeK(allx = lalonde[,xvars], useasbases = 1-lalonde$nsw)

#svd on this kernel
svd_pass = svd(K)  
#let's use the original weights of 1/number of sampled units, and 1/number of target units
#this is the default if we pass in w as all 1's
biasbound(observed=(1-lalonde$nsw),
          target=lalonde$nsw,
          svd.out = svd_pass,
          w = rep(1,nrow(lalonde)), hilbertnorm=1)
 }
}
