% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activations.R
\name{activation_celu}
\alias{activation_celu}
\title{Continuously Differentiable Exponential Linear Unit.}
\usage{
activation_celu(x, alpha = 1)
}
\arguments{
\item{x}{Input tensor.}

\item{alpha}{The  value for the CeLU formulation. Defaults to \code{1.0}.}
}
\value{
A tensor, the result from applying the activation to the input tensor \code{x}.
}
\description{
The CeLU activation function is defined as:

\verb{celu(x) = alpha * (exp(x / alpha) - 1) for x < 0},\verb{celu(x) = x for x >= 0}.

where \code{alpha} is a scaling parameter that controls the activation's shape.
}
\section{Reference}{
\itemize{
\item \href{https://arxiv.org/abs/1704.07483}{Barron, J. T., 2017}
}
}

\seealso{
Other activations: \cr
\code{\link{activation_elu}()} \cr
\code{\link{activation_exponential}()} \cr
\code{\link{activation_gelu}()} \cr
\code{\link{activation_glu}()} \cr
\code{\link{activation_hard_shrink}()} \cr
\code{\link{activation_hard_sigmoid}()} \cr
\code{\link{activation_hard_tanh}()} \cr
\code{\link{activation_leaky_relu}()} \cr
\code{\link{activation_linear}()} \cr
\code{\link{activation_log_sigmoid}()} \cr
\code{\link{activation_log_softmax}()} \cr
\code{\link{activation_mish}()} \cr
\code{\link{activation_relu}()} \cr
\code{\link{activation_relu6}()} \cr
\code{\link{activation_selu}()} \cr
\code{\link{activation_sigmoid}()} \cr
\code{\link{activation_silu}()} \cr
\code{\link{activation_soft_shrink}()} \cr
\code{\link{activation_softmax}()} \cr
\code{\link{activation_softplus}()} \cr
\code{\link{activation_softsign}()} \cr
\code{\link{activation_sparse_plus}()} \cr
\code{\link{activation_sparsemax}()} \cr
\code{\link{activation_squareplus}()} \cr
\code{\link{activation_tanh}()} \cr
\code{\link{activation_tanh_shrink}()} \cr
\code{\link{activation_threshold}()} \cr
}
\concept{activations}
