% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{metric_pearson_correlation}
\alias{metric_pearson_correlation}
\title{Calculates the Pearson Correlation Coefficient (PCC).}
\usage{
metric_pearson_correlation(
  y_true,
  y_pred,
  axis = -1L,
  ...,
  name = "pearson_correlation",
  dtype = NULL
)
}
\arguments{
\item{y_true}{Tensor of true targets.}

\item{y_pred}{Tensor of predicted targets.}

\item{axis}{(Optional) integer or tuple of integers of the axis/axes along
which to compute the metric. Defaults to \code{-1}.}

\item{...}{For forward/backward compatability.}

\item{name}{(Optional) string name of the metric instance.}

\item{dtype}{(Optional) data type of the metric result.}
}
\description{
Formula:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{loss = mean(l2norm(y_true - mean(y_true) * l2norm(y_pred - mean(y_pred)))
}\if{html}{\out{</div>}}

PCC measures the linear relationship between the true values (\code{y_true}) and
the predicted values (\code{y_pred}). The coefficient ranges from -1 to 1, where
a value of 1 implies a perfect positive linear correlation, 0 indicates no
linear correlation, and -1 indicates a perfect negative linear correlation.

This metric is widely used in regression tasks where the strength of the
linear relationship between predictions and true labels is an
important evaluation criterion.
}
\section{Examples}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{pcc <- metric_pearson_correlation(axis = -1)
y_true <- rbind(c(0, 1, 0.5),
                c(1, 1, 0.2))
y_pred <- rbind(c(0.1, 0.9, 0.5),
                c(1, 0.9, 0.2))
pcc$update_state(y_true, y_pred)
pcc$result()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## tf.Tensor(0.99669963, shape=(), dtype=float32)

}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# equivalent operation using R's stats::cor()
mean(sapply(1:nrow(y_true), function(i) \{
  cor(y_true[i, ], y_pred[i, ])
\}))
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## [1] 0.9966996

}\if{html}{\out{</div>}}

Usage with \code{compile()} API:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{model |> compile(
  optimizer = 'sgd',
  loss = 'mean_squared_error',
  metrics = c(keras.metrics.PearsonCorrelation())
)
}\if{html}{\out{</div>}}
}

\seealso{
Other regression metrics: \cr
\code{\link{metric_concordance_correlation}()} \cr
\code{\link{metric_cosine_similarity}()} \cr
\code{\link{metric_log_cosh_error}()} \cr
\code{\link{metric_mean_absolute_error}()} \cr
\code{\link{metric_mean_absolute_percentage_error}()} \cr
\code{\link{metric_mean_squared_error}()} \cr
\code{\link{metric_mean_squared_logarithmic_error}()} \cr
\code{\link{metric_r2_score}()} \cr
\code{\link{metric_root_mean_squared_error}()} \cr

Other metrics: \cr
\code{\link{Metric}()} \cr
\code{\link{custom_metric}()} \cr
\code{\link{metric_auc}()} \cr
\code{\link{metric_binary_accuracy}()} \cr
\code{\link{metric_binary_crossentropy}()} \cr
\code{\link{metric_binary_focal_crossentropy}()} \cr
\code{\link{metric_binary_iou}()} \cr
\code{\link{metric_categorical_accuracy}()} \cr
\code{\link{metric_categorical_crossentropy}()} \cr
\code{\link{metric_categorical_focal_crossentropy}()} \cr
\code{\link{metric_categorical_hinge}()} \cr
\code{\link{metric_concordance_correlation}()} \cr
\code{\link{metric_cosine_similarity}()} \cr
\code{\link{metric_f1_score}()} \cr
\code{\link{metric_false_negatives}()} \cr
\code{\link{metric_false_positives}()} \cr
\code{\link{metric_fbeta_score}()} \cr
\code{\link{metric_hinge}()} \cr
\code{\link{metric_huber}()} \cr
\code{\link{metric_iou}()} \cr
\code{\link{metric_kl_divergence}()} \cr
\code{\link{metric_log_cosh}()} \cr
\code{\link{metric_log_cosh_error}()} \cr
\code{\link{metric_mean}()} \cr
\code{\link{metric_mean_absolute_error}()} \cr
\code{\link{metric_mean_absolute_percentage_error}()} \cr
\code{\link{metric_mean_iou}()} \cr
\code{\link{metric_mean_squared_error}()} \cr
\code{\link{metric_mean_squared_logarithmic_error}()} \cr
\code{\link{metric_mean_wrapper}()} \cr
\code{\link{metric_one_hot_iou}()} \cr
\code{\link{metric_one_hot_mean_iou}()} \cr
\code{\link{metric_poisson}()} \cr
\code{\link{metric_precision}()} \cr
\code{\link{metric_precision_at_recall}()} \cr
\code{\link{metric_r2_score}()} \cr
\code{\link{metric_recall}()} \cr
\code{\link{metric_recall_at_precision}()} \cr
\code{\link{metric_root_mean_squared_error}()} \cr
\code{\link{metric_sensitivity_at_specificity}()} \cr
\code{\link{metric_sparse_categorical_accuracy}()} \cr
\code{\link{metric_sparse_categorical_crossentropy}()} \cr
\code{\link{metric_sparse_top_k_categorical_accuracy}()} \cr
\code{\link{metric_specificity_at_sensitivity}()} \cr
\code{\link{metric_squared_hinge}()} \cr
\code{\link{metric_sum}()} \cr
\code{\link{metric_top_k_categorical_accuracy}()} \cr
\code{\link{metric_true_negatives}()} \cr
\code{\link{metric_true_positives}()} \cr
}
\concept{metrics}
\concept{regression metrics}
