% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keras_tools.R
\name{keras_evaluate}
\alias{keras_evaluate}
\title{Evaluate a Kerasnip Model}
\usage{
keras_evaluate(object, x, y = NULL, ...)
}
\arguments{
\item{object}{A \code{model_fit} object produced by a \code{kerasnip} specification.}

\item{x}{A data frame or matrix of new predictor data.}

\item{y}{A vector or data frame of new outcome data corresponding to \code{x}.}

\item{...}{Additional arguments passed on to \code{keras3::evaluate()} (e.g.,
\code{batch_size}).}
}
\value{
A named list containing the evaluation results (e.g., \code{loss},
\code{accuracy}). The names are determined by the metrics the model was compiled
with.
}
\description{
This function provides an \code{kera_evaluate()} method for \code{model_fit} objects
created by \code{kerasnip}. It preprocesses the new data into the format expected
by Keras and then calls \code{keras3::evaluate()} on the underlying model to compute
the loss and any other metrics.
}
\details{
Evaluate a Fitted Kerasnip Model on New Data
}
\examples{
\donttest{
if (requireNamespace("keras3", quietly = TRUE)) {
library(keras3)
library(parsnip)

# 1. Define layer blocks
input_block <- function(model, input_shape) {
  keras_model_sequential(input_shape = input_shape)
}
hidden_block <- function(model, units = 32) {
  model |> layer_dense(units = units, activation = "relu")
}
output_block <- function(model, num_classes) {
  model |> layer_dense(units = num_classes, activation = "softmax")
}

# 2. Define and fit a model ----
create_keras_sequential_spec(
  model_name = "my_mlp_tools",
  layer_blocks = list(
    input = input_block,
    hidden = hidden_block,
    output = output_block
  ),
  mode = "classification"
)

mlp_spec <- my_mlp_tools(
  hidden_units = 32,
  compile_loss = "categorical_crossentropy",
  compile_optimizer = "adam",
  compile_metrics = "accuracy",
  fit_epochs = 5
) |> set_engine("keras")

x_train <- matrix(rnorm(100 * 10), ncol = 10)
y_train <- factor(sample(0:1, 100, replace = TRUE))
train_df <- data.frame(x = I(x_train), y = y_train)

fitted_mlp <- fit(mlp_spec, y ~ x, data = train_df)

# 3. Evaluate the model on new data ----
x_test <- matrix(rnorm(50 * 10), ncol = 10)
y_test <- factor(sample(0:1, 50, replace = TRUE))

eval_metrics <- keras_evaluate(fitted_mlp, x_test, y_test)
print(eval_metrics)

# 4. Extract the Keras model object ----
keras_model <- extract_keras_model(fitted_mlp)
summary(keras_model)

# 5. Extract the training history ----
history <- extract_keras_history(fitted_mlp)
plot(history)
remove_keras_spec("my_mlp_tools")
}
}
}
