% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hyperclass.R
\name{Tuner_class}
\alias{Tuner_class}
\title{Tuner}
\usage{
Tuner_class(
  oracle,
  hypermodel,
  max_model_size = NULL,
  optimizer = NULL,
  loss = NULL,
  metrics = NULL,
  distribution_strategy = NULL,
  directory = NULL,
  project_name = NULL,
  logger = NULL,
  tuner_id = NULL,
  overwrite = FALSE,
  executions_per_trial = 1
)
}
\arguments{
\item{oracle}{Instance of Oracle class.}

\item{hypermodel}{Instance of HyperModel class (or 
callable that takes hyperparameters and returns a 
Model instance).}

\item{max_model_size}{Int. Maximum size of weights 
(in floating point coefficients) for a valid models. 
Models larger than this are rejected.}

\item{optimizer}{Optional. Optimizer instance. May be 
used to override the `optimizer` argument in the `compile` 
step for the models. If the hypermodel does not compile 
the models it generates, then this argument must be specified.}

\item{loss}{Optional. May be used to override the `loss` 
argument in the `compile` step for the models. If the 
hypermodel does not compile the models it generates, 
then this argument must be specified.}

\item{metrics}{Optional. May be used to override the `metrics` 
argument in the `compile` step for the models. If the hypermodel 
does not compile the models it generates, then this argument 
must be specified.}

\item{distribution_strategy}{Optional. A TensorFlow `tf$distribute` 
DistributionStrategy instance. If specified, each trial will run 
under this scope. For example, `tf$distribute.MirroredStrategy(['/gpu:0, /'gpu:1])` 
will run each trial on two GPUs. Currently only single-worker strategies are supported.}

\item{directory}{String. Path to the working directory (relative).}

\item{project_name}{Name to use as prefix for files saved by this Tuner.}

\item{logger}{Optional. Instance of Logger class, used for 
streaming data to Cloud Service for monitoring.}

\item{tuner_id}{tuner_id}

\item{overwrite}{Bool, default `FALSE`. If `FALSE`, reloads an 
existing project of the same name if one is found. Otherwise, overwrites the project.}

\item{executions_per_trial}{Integer, the number of executions 
(training a model from scratch, starting from a new initialization) to run per trial 
(model configuration). Model metrics may vary greatly depending on random initialization, 
hence it is often a good idea to run several executions per trial 
in order to evaluate the performance of a given set of hyperparameter values. 
**kwargs: Arguments for `BaseTuner`.}
}
\value{
a tuner object
}
\description{
Tuner class for Keras models.
}
\details{
May be subclassed to create new tuners.
}
