% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importancies.R
\name{aggregate_imp}
\alias{aggregate_imp}
\title{Aggregate importances}
\usage{
aggregate_imp(X, lev = NULL, samples = "rows")
}
\arguments{
\item{X}{Matrix or data.frame containing the importances (in rows or in columns).}

\item{lev}{(optional) The grouping elements. `lev` should be as long as the dimension (cols or rows)
that one wants to aggregate. If this parameter is absent, the colnames (if samples="rows") or rownames will
be used to that effect. In that case, it is expected that the col/rownames follow
this pattern: "V_Y", and the variables with the same "V" will be summed. (Check the colnames of
a typical output of `dummy_data()` for more info).}

\item{samples}{Samples are in rows or in columns? (Defaults: "rows").}
}
\value{
X, a matrix or data.frame containing the aggregated importances.
}
\description{
`aggregate_imp()` sums the importances present in a matrix or data.frame according
to some user-specified grouping criterion.
}
\examples{
importances <- matrix(rnorm(90),nrow=3,ncol=30)
rownames(importances) <- c("sample1","sample2","sample3")
colnames(importances) <- paste0("Feat",
rep(1:5,times=2*(1:5)), "_", unlist(lapply(2*(1:5),function(x)LETTERS[1:x])))

## The grouping criterion is:
groups <- paste0("Feat",1:5)
aggregate_imp(X=importances,samples="rows",lev=groups)
## We can also use the colnames:
colnames(importances)
aggregate_imp(X=importances,samples="rows")
}
