% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_study.R
\name{estimate_gamma}
\alias{estimate_gamma}
\title{Gamma hyperparameter estimation (RBF kernel)}
\usage{
estimate_gamma(X)
}
\arguments{
\item{X}{Matrix or data.frame that contains real numbers ("integer", "float" or "double").}
}
\value{
A list with the gamma value estimation according to different criteria.
}
\description{
This function returns an estimation of the optimum value for the gamma hyperparameter
(required by the RBF kernel function) using different heuristics:

\describe{
  \item{\emph{D} criterion}{It returns the inverse of the number of features in X.}
  \item{Scale criterion}{It returns the inverse of the number of features,
  normalized by the total variance of X.}
  \item{Quantiles criterion}{A range of values, computed with the function
  `kernlab::sigest()`.}
}
}
\examples{
data <- matrix(rnorm(150),ncol=50,nrow=30)
gamma <- estimate_gamma(data)
gamma
K <- RBF(data, g = gamma$scale_criterion)
K[1:5,1:5]
}
