% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_study.R
\name{simK}
\alias{simK}
\title{Kernel matrix similarity}
\usage{
simK(Klist)
}
\arguments{
\item{Klist}{A list of \emph{M} kernel matrices with identical \emph{NxN} dimension.}
}
\value{
Kernel matrix (dimension: \emph{MxM}).
}
\description{
`simK()` computes the similarity between kernel matrices.
}
\details{
It is a wrapper of `Frobenius()`.
}
\examples{
K1 <- Linear(matrix(rnorm(7500),ncol=150,nrow=50))
K2 <- Linear(matrix(rnorm(7500),ncol=150,nrow=50))
K3 <- Linear(matrix(rnorm(7500),ncol=150,nrow=50))

simK(list(K1,K2,K3))
}
