% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decrypt_dpapi_pw.R
\name{decrypt_dpapi_pw}
\alias{decrypt_dpapi_pw}
\title{Decrypt passwords encrypted with  the Microsoft Data Protection API}
\usage{
decrypt_dpapi_pw(file)
}
\arguments{
\item{file}{File that holds a password encrypted using DPAPI}
}
\value{
An decrypted password as an invisible string.  Invisible means that
the password won't be displayed in the console, but can be assigned to a
variable or used inline.
}
\description{
Decrypt passwords encrypted with  the Microsoft Data Protection API
}
\details{
Requires Powershell to be installed and execution policy set to RemoteSigned.
This can be achieved by running
\code{
Set-ExecutionPolicy RemoteSigned
}
from Powershell.
}
\examples{
\dontrun{
# First run the command below from Powershell:
# Read-Host "PW?" -AsSecureString |  ConvertFrom-SecureString | Out-File "C:\\Temp\\Password.txt"
# Now execute the following R commands to decrypt the password and save it in
# variable "x".  Note that if run without assignment, the password will not
# be displayed in the console.  Passwords must be saved to a variable or used
# inline within a connection string.
library("keyringr")
x <- decrypt_dpapi_pw("C:\\\\Temp\\\\Password.txt")

# function is best used in a connection string command:
ch <- odbcConnect("some dsn", uid = "user1", pwd = decrypt_dpapi_pw("C:\\\\Temp\\\\Password.txt"))
}
}
