% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/egfr_other_adults.R
\name{egfr.cg.cr}
\alias{egfr.cg.cr}
\title{Calculate creatinine clearance by the Cockcroft-Gault equation}
\usage{
egfr.cg.cr(
  creatinine,
  age,
  sex,
  weight,
  creatinine_units = "micromol/l",
  label_sex_male = c("Male", 1),
  label_sex_female = c("Female", 0),
  max_age = 100
)
}
\arguments{
\item{creatinine}{Numeric vector. Serum creatinine, could be expressed in "micromol/L", "mmol/L" or "mg/dL". Units of measurement should be defined in variable creatinine_units (if not defined explicitly by user, the default value is "micromol/L").}

\item{age}{Numeric vector. Age, in years.}

\item{sex}{Vector. The value of variable refers to the parameters label_sex_male and label_sex_female.}

\item{weight}{Numeric vector. Weight, kg.}

\item{creatinine_units}{Character string. Units in which serum creatinne is expressed. Could be one of the following: "micromol/L", "mmol/L" or "mg/dL".}

\item{label_sex_male}{List. Label(s) for definition(s) of male sex.}

\item{label_sex_female}{List. Label(s) for definition(s) of female sex.}

\item{max_age}{Numeric. Maximal age suitable for the equation application, in years. By default is 100 years, but change this value in case you would like to apply equation to older persons.}
}
\value{
numeric creatinine clearance expressed in ml/min/1.73m\ifelse{html}{\out{<sup>2</sup>}}{\eqn{^2}}.
}
\description{
Calculate creatinine clearance by the Cockcroft-Gault equation
}
\details{
Calculate Cockcroft-Gault by the Cockcroft-Gault equation.

Reference to the equation: Cockcroft, DW, Gault MH. Prediction of creatinine clearance from serum creatinine. Nephron. 1976. 16(1):31-41.

Citation: Bikbov B. kidney.epi: Kidney-Related Functions for Clinical and Epidemiological Research. Scientific-Tools.Org, https://Scientific-Tools.Org. DOI: 10.32614/CRAN.package.kidney.epi
}
\examples{
# for a single patient
egfr.cg.cr (creatinine = 1.4, age = 60, sex = "Male",
  weight = 80, creatinine_units = "mg/dl")
# for a dataset - see vignettes for details
}
\author{
Programming: Boris Bikbov https://www.linkedin.com/in/boris-bikbov.
}
