% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/egfr_schwartz.R
\name{egfr.schwartz.cys}
\alias{egfr.schwartz.cys}
\title{Calculate eGFR by Schwartz cystatin C-based equation (for children only)}
\usage{
egfr.schwartz.cys(cystatin, cystatin_units = "mg/L")
}
\arguments{
\item{cystatin}{Numeric vector. Serum cystatin, could be expressed in "mg/L" or "nanomol/L". Units of measurement should be defined in variable cystatin_units (if not defined explicitly by user, the default value is "mg/L").}

\item{cystatin_units}{Character string. Units in which serum cystatin is expressed. Could be one of the following: "mg/L" or "nanomol/L"}
}
\value{
numeric eGFR expressed in ml/min/1.73m\ifelse{html}{\out{<sup>2</sup>}}{\eqn{^2}}.
}
\description{
Calculate eGFR by Schwartz cystatin C-based equation (for children only)
}
\details{
Calculate estimated glomerular filtration rate (eGFR) by Schwartz cystatin C-based equation.

Reference to the equation: Schwartz GJ, Schneider MF, Maier PS et al. Improved equations estimating GFR in children with chronic kidney disease using an immunonephelometric determination of cystatin C. Kidney Int 2012; 82: 445–453.

Citation: Bikbov B. kidney.epi: Kidney-Related Functions for Clinical and Epidemiological Research. Scientific-Tools.Org, https://Scientific-Tools.Org. DOI: 10.32614/CRAN.package.kidney.epi
}
\examples{
# for a single patient
egfr.schwartz.cys(cystatin = 1.4)
# for a dataset - see vignettes for details
}
\author{
Programming: Boris Bikbov https://www.linkedin.com/in/boris-bikbov.
}
