% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STUDY_CANCER_GENES.R
\name{STUDY_CANCER_GENES}
\alias{STUDY_CANCER_GENES}
\title{Study k-mer composition of causal cancer genes from COSMIC Cancer Gene
Census (CGC) database.}
\usage{
STUDY_CANCER_GENES(
  cosmic.username,
  cosmic.password,
  tumour.type.regex = NULL,
  tumour.type.exact = NULL,
  cell.type = "somatic",
  genic.elements.counts.dt,
  output.dir = "study_cancer_genes/"
)
}
\arguments{
\item{cosmic.username}{COSMIC username i.e. registered email.}

\item{cosmic.password}{COSMIC password.}

\item{tumour.type.regex}{Regular expression for "Tumour Types" column in
Cancer Gene Census table. Default is NULL.}

\item{tumour.type.exact}{Exact keywords for "Tumour Types" column in
Cancer Gene Census table. Default is NULL.}

\item{cell.type}{Type of cell: "somatic" or "germline". Default is "somatic".}

\item{genic.elements.counts.dt}{Genic element count table generated from
STUDY_GENIC_ELEMENTS.}

\item{output.dir}{A directory for the outputs.}
}
\value{
An output directory containing plots.
}
\description{
Detail of Cancer Gene Census can be accessed and read at
https://cancer.sanger.ac.uk/census
}
