% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{countMidPatternKmers}
\alias{countMidPatternKmers}
\title{Count Relevant K-mers with Specified Middle Pattern from Sequence String(s)}
\usage{
countMidPatternKmers(sequences, k, mid_pattern)
}
\arguments{
\item{sequences}{A vector of strings, each representing a sequence to be analyzed.}

\item{k}{An integer specifying the size of the k-mers to be extracted and counted.}

\item{mid_pattern}{A string representing the middle pattern to search for within each sequence.}
}
\value{
A std::unordered_map with k-mers as keys and their counts as values.
}
\description{
This function scans through each sequence in the provided vector, locating a specified middle pattern.
For each occurrence of the middle pattern, the function extracts and counts the surrounding k-mers.
The k-mers are identified based on the given k-mer size and centered around the middle pattern.
}
