% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateGenicElementCoor.R
\name{generateGenicElementCoor}
\alias{generateGenicElementCoor}
\title{Function processes UCSC genePred tables to generate coordinates for
various genic elements like introns, exons, CDS, UTRs, and upstream and
downstream regions. It handles these coordinates with consideration for
strand sensitivity and genome information.}
\usage{
generateGenicElementCoor(
  genepred,
  element.names = "all",
  upstream = NULL,
  downstream = NULL,
  genome.name = NULL,
  genome = NULL,
  return.coor.obj = FALSE
)
}
\arguments{
\item{genepred}{UCSC genome name (e.g., hg19, mm39).}

\item{element.names}{Types of genic elements to output: "all", "intron",
"exon", "CDS", or "UTR". Default is "all".}

\item{upstream}{Length of upstream sequence (can overlap other genes).}

\item{downstream}{Length of downstream sequence (can overlap other genes).}

\item{genome.name}{UCSC genome name for trimming overflowing coordinates.}

\item{genome}{Genome object for coordinate resolution.}

\item{return.coor.obj}{Whether to return a \code{Coordinate} object (default: FALSE).}
}
\value{
Genic element coordinates in a \code{data.table} or \code{Coordinate} object.
}
\description{
All the operations in here are vectorized. If the table is big, expect a
spike in memory. Using ncbiRefSeq table and genome hg38, the memory is
stable at 4-5 GB. I can utilise data.table package to process by chunk if
needed.
Original table is zero-based open-end index. The indexing system is changed
temporarily to follow Rs system. The output coordinate table is one-based
close-end index. Critical information based on UCSC Genome website:
Column        Explanation
bin           Indexing field to speed chromosome range queries. (Only
relevant to UCSC program)
name 	     Name of gene (usually transcript_id from GTF)
chrom 	     Reference sequence chromosome or scaffold
strand 	     + or - for strand
txStart 	     Transcription start position (or end position for minus
strand item)
txEnd 	     Transcription end position (or start position for minus
strand item)
cdsStart      Coding region start (or end position for minus strand item)
cdsEnd 	     Coding region end (or start position for minus strand item)
exonCount     Number of exons
exonEnds      Exon end positions (or start positions for minus strand
item)
exonStart     Exon start positions (or end positions for minus strand
item)
name2 	     Alternate name (e.g. gene_id from GTF)
cdsStartStat  Status of CDS start annotation (none, unknown, incomplete,
or complete) = ('none','unk','incmpl','cmpl')
cdsEndStat    Status of CDS end annotation (none, unknown, incomplete,
or complete)
exonFrames    Exon frame (0,1,2), or -1 if no frame for exon (Related to
codon. Number represents extra bases (modulus of 3) from
previous exon block brought to a current exon block.)
If cdsStart == cdsEnd, that means non-coding sequence.
\itemize{
\item maybe cdsStartStat and cdsEndStat == "none" mean the same thing.
maybe exonFrames == "-1," means the same thing.
}
}
