% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{simulatePopulation}
\alias{simulatePopulation}
\title{Simulate a population given ranges of chromosome sequence to mutate.}
\usage{
simulatePopulation(
  chrom_seq,
  starts,
  ends,
  strand,
  snv_df,
  pop_size,
  top_kmers,
  central_pattern,
  k
)
}
\arguments{
\item{chrom_seq}{A chromosome sequence.}

\item{starts}{Start positions.}

\item{ends}{End positions.}

\item{strand}{Strand type: "+" or "-".}

\item{snv_df}{A table of SNV frequency. Columns: position, base, count.}

\item{pop_size}{Size of population.}

\item{top_kmers}{Extreme k-mers i.e. highly susceptible k-mers.}

\item{central_pattern}{K-mer central pattern.}

\item{k}{K-mer size.}
}
\value{
A count matrix with 4 rows for total top k-mers and susceptible
k-mers in sense and antisense. Columns correspond to population
individuals.
}
\description{
Simulate a population given ranges of chromosome sequence to mutate.
}
