% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{NYcity_subset}
\alias{NYcity_subset}
\title{New York City CCES Respondents in 2008}
\format{
The \code{NYcity_subset} dataset has 568 observations and 26 variables.
\describe{
  \item{\code{state}}{The state abbreviation of the respondent's residence.}
  \item{\code{zip}}{The respondent's ZIP code.}
  \item{\code{age}}{The age of the respondent in years.}
  \item{\code{female}}{An indicator of whether the respondent is female.}
  \item{\code{ideology}}{The respondent's self-reported ideology on a scale of 0 (liberal) to 100 (conservative).}
  \item{\code{educ}}{The respondent's level of education. 0=No Highschool, 
    1=High School Graduate, 2=Some College, 3=2-year Degree, 4=4-year degree, 5=Post-Graduate.}
  \item{\code{race}}{The respondent's race. 1=White, 2=African American, 3=Nonwhite & nonblack.}
  \item{\code{empstat}}{The respondent's employment status. 1=employed, 2=unemployed, 3=not in workforce.}
  \item{\code{ownership}}{Indicator for whether the respondent owns his or her own home.}
  \item{\code{inc14}}{The respondent's self reported income. 1=Less than $10,000, 
    2=$10,000-$14,999, 3=$15,000-$19,000, 4=$20,000-$24,999, 5=$25,000-$29,999, 
    6=$30,000-$39,999, 7=$40,000-$49,999, 8=$50,000-$59,999, 9=$60,000-$69,999, 
    10=$70,000-$79,999, 11=$80,000-$89,999, 12=$100,000-$119,999, 13=$120,000-$149,999, 
    14=$150,000 or more.}
  \item{\code{catholic}}{Indicator for whether the respondent is Catholic.}
  \item{\code{mormon}}{Indicator for whether the respondent is Mormon.}
  \item{\code{orthodox}}{Indicator for whether the respondent is Orthodox Christian.}
  \item{\code{jewish}}{Indicator for whether the respondent is Jewish.}
  \item{\code{islam}}{Indicator for whether the respondent is Muslim.}
  \item{\code{mainline}}{Indicator for whether the respondent is Mainline Christian.}
  \item{\code{evangelical}}{Indicator for whether the respondent is Evangelical Christian.}
  \item{\code{FIPS_Code}}{FIPS code of the repondent's state.}
  \item{\code{rural}}{Nine-point USDA scale of the ruralism of each county, with 
    0 meaning the most urban and 8 meaning the most rural.}
  \item{\code{zipPop}}{Indicates the population of the repondent's ZIP code.}
  \item{\code{zipLandKM}}{Indicates the land area in square kilometers of the repondent's ZIP code.}
  \item{\code{weight}}{Survey weights created by the CCES.}
  \item{\code{cd}}{The congressional district the respondent resides in.}
  \item{\code{fipsCD}}{Index that fuses the state FIPS code in the first two 
    digits and the congressional district number in the last two digits.}
  \item{\code{northings}}{Indicates the geographical location of the respondent in kilometer-based northings.}
  \item{\code{eastings}}{Indicates the geographical location of the respondent in kilometer-based eastings.}
}
}
\source{
{
Ansolabehere, Stephen. 2011. "CCES, Common Content, 2008." Ver. 4.

ArcGIS. 2012. "USA ZIP Code Areas."  \url{https://www.arcgis.com/home/item.html?id=8d2012a2016e484dafaac0451f9aea24}

United States Department of Agriculture. 2013. "2013 Rural-Urban Continuum Codes." \url{https://www.ers.usda.gov/data-products/rural-urban-continuum-codes.aspx}
}
}
\description{
These data are a subset of the 2008 Cooperative Congressional Election Survey 
(CCES) Common Content. Only 568 respondents from New York City are included, 
with predictors drawn from Gill's (2020) model of self-reported ideology. The 
CCES data are merged with predictors on geographic location based on ZIP codes 
(from ArcGIS & TomTom) and county ruralism (from the USDA).
}
\examples{
        
\dontrun{
nyc <- NYcity_subset

#data cleaning
nyc$cathOrth<-nyc$catholic+nyc$orthodox
nyc$consRelig<-nyc$mormon+nyc$evangelical
nyc$jewMus<-nyc$jewish+nyc$islam

# Explanatory Variable Matrix
psrm.data <-cbind(nyc$age, nyc$educ, I(nyc$age*nyc$educ), as.numeric(nyc$race==2), 
       as.numeric(nyc$race==3), nyc$female, I(as.numeric(nyc$race==2)*nyc$female), 
       I(as.numeric(nyc$race==3)*nyc$female), nyc$cathOrth, nyc$consRelig, 
       nyc$jewMus, nyc$mainline, nyc$rural, nyc$ownership, 
       as.numeric(nyc$empstat==2), as.numeric(nyc$empstat==3),nyc$inc14)

dimnames(psrm.data)[[2]] <- c("Age", "Education", "Age.education", 
                             "African.American", "Nonwhite.nonblack","Female", 
                             "African.American.female", "Nonwhite.nonblack.female", 
                             "Catholic.Orthodox", "Evang.Mormon", "Jewish.Muslim", 
                             "Mainline","Ruralism", "Homeowner", "Unemployed",
                             "Not.in.workforce","Income")

# Outcome Variable
ideo <- matrix(nyc$ideology,ncol=1)

# WARNING: This example was tuned on Amazon Web Services (EC2) over many hours
# with 150,000 iterations--a strain in 2020 for most desktop machines.
# A test with few iterations allows illustration.
#M<-150000 
M<-150 
set.seed(1,kind="Mersenne-Twister")

# Estimate the Model
nyc.fit <- metropolis.krige(formula = ideo ~ psrm.data, coords = cbind(nyc$eastings, nyc$northings),
          powered.exp=1, n.iter=M, spatial.share=0.31,range.share=0.23,beta.var=10,
          range.tol=0.01, b.tune=0.1, nugget.tune=20, psill.tune=5)		
      
# Discard first 20\% of Iterations as Burn-In (User Discretion Advised).
nyc.fit <- burnin(nyc.fit, M/5)

# Summarize Results
summary(nyc.fit)

#Convergence Diagnostics: Geweke and Heidelberger-Welch
geweke(nyc.fit)
heidel.welch(nyc.fit)

# Draw Semivariogram
semivariogram(nyc.fit)
}     
}
\references{
Jeff Gill. 2020. Measuring Constituency Ideology Using Bayesian Universal Kriging. 
    \emph{State Politics & Policy Quarterly}. \code{doi:10.1177/1532440020930197}
}
\keyword{data}
