% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/krippendorff.R
\name{influence.krippendorffsalpha}
\alias{influence.krippendorffsalpha}
\title{Compute DFBETAs for units and/or coders.}
\usage{
\method{influence}{krippendorffsalpha}(model, units, coders, ...)
}
\arguments{
\item{model}{a fitted model object, the result of a call to \code{\link{krippendorffs.alpha}}.}

\item{units}{a vector of integers. A DFBETA will be computed for each of the corresponding units.}

\item{coders}{a vector of integers. A DFBETA will be computed for each of the corresponding coders.}

\item{...}{additional arguments. These are ignored.}
}
\value{
A list comprising at most two elements.
        \item{dfbeta.units}{a vector containing DFBETAs for the units specified via argument \code{units}.}
        \item{dfbeta.coders}{a vector containing DFBETAs for the coders specified via argument \code{coders}.}
}
\description{
Compute DFBETAs for units and/or coders.
}
\details{
This function computes DFBETAs for one or more units and/or one or more coders.
}
\examples{
# The following data were presented in Krippendorff (2013). This example
# applies Hughes' methodology to the data (method = "analytical", the default).
# DFBETAS are computed by leaving out unit 6, unit 11, coder 2, and coder 3.

nominal = matrix(c(1,2,3,3,2,1,4,1,2,NA,NA,NA,
                   1,2,3,3,2,2,4,1,2,5,NA,3,
                   NA,3,3,3,2,3,4,2,2,5,1,NA,
                   1,2,3,3,2,4,4,1,2,5,1,NA), 12, 4)
fit.nom = krippendorffs.alpha(nominal, level = "nominal", confint = FALSE)
summary(fit.nom)
(inf = influence(fit.nom, units = c(6, 11), coders = c(2, 3)))
}
\references{
Young, D. S. (2017). \emph{Handbook of Regression Methods}. CRC Press.

Krippendorff, K. (2013). Computing Krippendorff's alpha-reliability. Technical report, University of Pennsylvania.
}
