% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/krippendorff.R
\name{summary.krippendorffsalpha}
\alias{summary.krippendorffsalpha}
\title{Print a summary of a Krippendorff's Alpha fit.}
\usage{
\method{summary}{krippendorffsalpha}(object, conf.level = 0.95, digits = 4, ...)
}
\arguments{
\item{object}{an object of class \code{"krippendorffsalpha"}, the result of a call to \code{\link{krippendorffs.alpha}}.}

\item{conf.level}{the confidence level for the confidence intervals. The default is 0.95.}

\item{digits}{the number of significant digits to display. The default is 4.}

\item{\dots}{additional arguments. These are passed to \code{\link{quantile}}.}
}
\description{
Print a summary of a Krippendorff's Alpha fit.
}
\details{
This function prints a summary of the fit. First the data geometry is described, then the call signature is printed, then the values of the control parameters (defaults and/or values supplied in the call) are printed. Finally, a table of estimates is shown. If applicable, the table includes confidence limits.
}
\examples{
# Fit a subset of the cartilage data, using the customary methodology.
# Compute bootstrap confidence intervals using a bootstrap sample size
# of 1,000. Display a summary of the results, including a 99\% confidence
# interval. Also plot the results.

data(cartilage)
cartilage = as.matrix(cartilage[1:100, ])
fit.cart = krippendorffs.alpha(cartilage, level = "ratio", method = "customary", confint = TRUE,
                               control = list(bootit = 1000, parallel = FALSE))
summary(fit.cart, conf.level = 0.99)
dev.new()
plot(fit.cart, xlim = c(0.7, 0.9), xlab = "Bootstrap Estimates",
     main = "Results for Cartilage Data")
}
\references{
Nissi, M. J., Mortazavi, S., Hughes, J., Morgan, P., and Ellermann, J. (2015). T2* relaxation time of acetabular and femoral cartilage with and without intra-articular Gd-DTPA2 in patients with femoroacetabular impingement. \emph{American Journal of Roentgenology}, \bold{204}(6), W695.
}
\seealso{
\code{\link{krippendorffs.alpha}}
}
