% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{.ktaucenters_run}
\alias{.ktaucenters_run}
\title{Robust Clustering algorithm based on centers, a robust and efficient version
of kmeans.}
\usage{
.ktaucenters_run(x, centers, tolerance, max_iter)
}
\arguments{
\item{x}{numeric matrix of size n x p with all observations.}

\item{centers}{numeric matrix with initial cluster centers.}

\item{tolerance}{maximum difference between current and new computed
clusters. Parameter used for the algorithm stopping rule.}

\item{max_iter}{a maximum number of iterations used for the algorithm
stopping rule.}
}
\value{
A list with the following components:
\item{tau }{\eqn{\tau} scale value. }
\item{iter }{number of iterations until convergence is achieved or maximum
number of iteration is reached. }
\item{di }{distance of each observation to its nearest cluster center. }
\item{centers }{numeric matrix of size K x p, with the estimated K centers.
 }
\item{clusters }{integer vector of size n with the cluster location for each
observation. }
}
\description{
Robust Clustering algorithm based on centers, a robust and efficient version
of kmeans.
}
\references{
[1] Gonzalez, J. D., Yohai, V. J., & Zamar, R. H. (2019).
Robust Clustering Using Tau-Scales. arXiv preprint arXiv:1906.08198.

[2] Maronna, R. A. and Yohai, V. J. (2017). Robust and efficient estimation
of multivariate scatter and location.Computational Statistics &Data
Analysis, 109 : 64–75.
}
