% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{as_tidygraph}
\alias{as_tidygraph}
\title{Convert a Kuzu Query Result to a tidygraph Object}
\usage{
as_tidygraph(query_result)
}
\arguments{
\item{query_result}{A \code{kuzu_query_result} object from \code{kuzu_execute()} that
contains a graph.}
}
\value{
A \code{tbl_graph} object.
}
\description{
Converts a Kuzu query result into a \code{tidygraph} \code{tbl_graph} object.
}
\examples{
\donttest{
if (requireNamespace("tidygraph", quietly = TRUE)) {
  conn <- kuzu_connection(":memory:")
  kuzu_execute(conn, "CREATE NODE TABLE Person(name STRING, 
  PRIMARY KEY (name))")
  kuzu_execute(conn, "CREATE (p:Person {name: 'Alice'})")
  res <- kuzu_execute(conn, "MATCH (p:Person) RETURN p")
  g_tidy <- as_tidygraph(res)
  print(g_tidy)
  rm(conn, res, g_tidy)
}
}
}
