% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_factor_info.R
\name{add_factor_info}
\alias{add_factor_info}
\title{Add Factor-specific Attributes to a Data Frame}
\usage{
add_factor_info(data)
}
\arguments{
\item{data}{the data.frame to which you wish to add labelr-specific factor
variable meta-data attributes (if any factors are present).}
}
\value{
a data.frame.
}
\description{
\code{add_factor_info} searches a data.frame for labelr-specific factor meta-data,
which it records and retains for future use. It is used by other labelr
functions and need not be used directly by labelr end users.
}
\examples{
# this function does not strictly require prior or other use of labelr
ir2 <- add_factor_info(iris)
mt2 <- add_factor_info(mtcars)
get_factor_info(mtcars) # none
get_factor_info(iris) # none
get_factor_info(mt2) # none
get_factor_info(ir2) # some!
}
