% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSimplex3D.R
\name{plotSimplex3D}
\alias{plotSimplex3D}
\title{Draws a three dimentional plot of the vertexes in a simplex}
\usage{
plotSimplex3D(simplex, sel.dim = NULL, all.ver = TRUE, all.lin = TRUE,
  main = NULL, angle = 30, ...)
}
\arguments{
\item{simplex}{object of class \code{smplx} with the simplex
information. See \code{\link{labsimplex}}}

\item{sel.dim}{\code{numeric} or \code{char} vector for variables to be
considered when simplex dimensionality is higher than 3.
By default, the first three are chosen. If the vector is
\code{numeric}, it must contain the ordinal numbers
corresponding to the desired variables. If the vector is of
class \code{char}, it must contain the names of such
dimensions.}

\item{all.ver}{logical default to \code{TRUE}. Should all vertexes be
plotted? If \code{FALSE}, the function draws only the
vertexes of the current simplex.}

\item{all.lin}{logical default to \code{TRUE}. Should all lines be drawn?
If \code{FALSE}, the function draws only the lines of the
last simplex.}

\item{main}{title for the plot.}

\item{angle}{angle for perspective between x and y axis.}

\item{...}{other arguments passed to
\code{\link[scatterplot3d]{scatterplot3d}}}
}
\value{
3D plot of the simplex coordinates.
}
\description{
The function generates a 3D plot of the vertexes in a simplex optimization
when simplex dimensionality is at least 3. When dimensionality is higher
than 3, the plot produced is a projection of the selected variables.
}
\examples{
  plotSimplex3D(simplex = labsimplex(n = 3, centroid = c(350, 11, 0.7),
                                     stepsize = c(10, 0.5, 0.1),
                                     var.name = c('temperature', 'pH',
                                                  'concentration')))

  ## Several options are posible when visualizing higher order simplexes
  plotSimplex3D(simplex = labsimplex(n = 8))
  plotSimplex3D(simplex = labsimplex(n = 8), sel.dim = c(4, 6, 8))

  ## Simplex movements can be visualized after some experiments has been
  ## performed
  simplex <- exampleOptimization(surface = exampleSurfaceR3,
                                 centroid = c(350, 11, 0.7),
                                 stepsize = c(10, 0.5, 0.1),
                                 experiments = 18)
  plotSimplex3D(simplex = simplex, angle = 80)
}
\seealso{
\code{\link{plot.smplx}}
}
\author{
Cristhian Paredes, \email{craparedesca@unal.edu.co}

Jesús Ágreda, \email{jagreda@unal.edu.co}
}
