% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incidence.R
\name{im.merge}
\alias{im.merge}
\title{Merge Two Incidence Matrices}
\usage{
im.merge(obj1, obj2)
}
\arguments{
\item{obj1, obj2}{Two incidence matrices of any size.}
}
\value{
A single incidence matrix.
}
\description{
From two incidience matrices, create a single incidence matrix. Matrices may contain same row or column elements.
}
\examples{
data(quattrofontanili)
qf1 <- quattrofontanili[1:20, 1:40]
qf1 <- qf1[rowSums(qf1) != 0, colSums(qf1) != 0]

qf2 <- quattrofontanili[30:50, 20:60]
qf2 <- qf2[rowSums(qf2) != 0, colSums(qf2) != 0]

im.merge(qf1, qf2)

}
