% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temporary-instance.R
\name{use_temporary_instance}
\alias{use_temporary_instance}
\title{Use a temporary LaminDB instance}
\usage{
use_temporary_instance(
  name = "laminr-temp",
  modules = NULL,
  add_timestamp = TRUE,
  envir = parent.frame()
)
}
\arguments{
\item{name}{A name for the temporary instance}

\item{modules}{A vector of modules to include (e.g. "bionty")}

\item{add_timestamp}{Whether to append a time stamp to \code{name} to make it
unique}

\item{envir}{An environment passed to \code{\link[withr:defer]{withr::defer()}}}
}
\description{
Create and connect to a temporary LaminDB instance to use for the current
session. This function is primarily intended for developers to use during
testing and documentation but can also be useful for users to debug issues
or create reproducible examples.
}
\details{
This function creates and connects to a temporary LaminDB instance. A
temporary storage folder is created and used to initialize a new instance. An
exit handler is registered with \code{\link[withr:defer]{withr::defer()}} that deletes the instance
and storage, then reconnects to the previous instance when \code{envir} finishes.

Switching to a temporary instance is not possible when another instance is
already connected.
}
