% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{landmix.estimator}
\alias{landmix.estimator}
\title{Dynamic landmark prediction estimator for mixture data with covariates}
\usage{
landmix.estimator(n, m, p, qvs, q, x, delta, ww, zz, run.NPNA,
  run.NPNA_avg, tval, tval0, z.use, w.use)
}
\arguments{
\item{n}{sample size, must be at least 1.}

\item{m}{number of different mixture proportions, must be at least 2.}

\item{p}{number of populations, must be at least 2.}

\item{qvs}{a numeric matrix of size \code{p} by \code{m} containing all possible
mixture proportions (i.e., the probability of belonging to each population k, k=1,...,p.).}

\item{q}{a numeric matrix of size \code{p} by \code{n} containing the
mixture proportions for each person in the sample.}

\item{x}{a numeric vector of length \code{n} containing the observed event times
for each person in the sample.}

\item{delta}{a numeric vector of length \code{n} that denotes
censoring (1 denotes event is observed, 0 denotes event is censored).}

\item{ww}{a numeric vector of length \code{n} containing the values of the continuous
covariate for each person in the sample.}

\item{zz}{a numeric vector of length \code{n} containing the values of the discrete
covariate for each person in the sample.}

\item{run.NPNA}{a logical indicator. If TRUE, then the output includes the
estimated distribution function for mixture data that accounts for covariates and dynamic
landmarking. This estimator is called "NPNA" in the referenced paper.}

\item{run.NPNA_avg}{a logical indicator. If TRUE, then the output includes the
estimated distribution function for mixture data that averages out over the observed covariates.
This is referred to as NPNA_marg in the referenced paper.}

\item{tval}{numeric vector of time points at which the distribution function is evaluated, all values must
be non-negative.}

\item{tval0}{numeric vector of time points representing the landmark times. All values must be non-negative
and smaller than the maximum of \code{tval}.}

\item{z.use}{numeric vector at which to evaluate the discrete covariate \eqn{Z} at in the estimated distribution function.
The values of \code{z.use} must be in the range of the observed \code{zz}.}

\item{w.use}{numeric vector at which to evaluate the continuous covariate \eqn{W} at in the estimated distribution function.
The values of \code{w.use} must be in the range of the observed \code{ww}.}

}
\value{
\code{landmix.estimator} returns a list containing
\itemize{
   \item{Ft.estimate: }{a numeric array containing the estimated distribution functions for all methods for all
   \code{p} populations. The distribution function is evaluated at each \code{tval},
   \code{tval0}, \code{z.use}, \code{w.use}, and for all \code{p} populations.
   The dimension of the array is the number of methods by \code{length(tval)} by \code{lenth(tval0)} by
   \code{length(z.use)} by \code{length(w.use)} by \code{p}.  The distribution function is only valid for \eqn{t\geq t_0}, so
   \code{Ft.estimate} shows NA for any combination for which \eqn{t<t_0}.
   }

   \item {St.estimate: }{a numeric array containing the estimated distribution functions for all methods
   for all \code{m} mixture proportion subgroups. The distribution function is evaluated
   at each \code{tval}, \code{tval0}, \code{z.use}, \code{w.use}, and for all \code{m} mixture
   proportion subgroups.
   The dimension of the array is the number of methods by \code{length(tval)} by \code{lenth(tval0)} by
   \code{length(z.use)} by \code{length(w.use)} by \code{m}.  The distribution function is only valid for \eqn{t\geq t_0}, so
   \code{St.estimate} shows NA for any combination for which \eqn{t<t_0}.
   }

   
}
}
\description{
Estimates the distribution function for mixture data where
the population identifiers are unknown, but the probability of belonging
to a population is known. The distribution functions are evaluated at
time points \code{tval} and adjust for dynamic landmark prediction and one
discrete covariate (\code{zz}) and one continuous covariate (\code{ww}).
}
\section{Details}{

We estimate the distribution function for mixture data  where
the population identifiers are unknown, but the probability of belonging
to a population is known. The distribution functions are evaluated at
time points \code{tval} and adjust for dynamic landmark prediction and one
discrete covariate (\code{zz}) and one continuous covariate (\code{ww}).
Dynamic landmark prediction means that the distribution function is computed knowing
that the survival time, \eqn{T}, satisfies \eqn{T >t_0}
where \eqn{t_0} are the time points in \code{tval0}.
}

\examples{
# Setup parameters to generate the data
set.seed(1)
censoring.rate <- 40
p <- 2
n <- 2000
m <- 4
tval <- seq(0,80,by=5)  
tval0 <- c(0,20,30,40,50)
z.use <- c(0,1)
w.use <- seq(35,55,by=1)
simu.setting <- "2A"
covariate.dependent <- TRUE
run.NPMLEs <- TRUE
run.NPNA <- TRUE
run.OLS <- FALSE
run.WLS <- FALSE
run.EFF <- FALSE
run.NPNA_avg <- FALSE


## compute the finite set of mixture proportions
qvs <- qvs.values(p,m)

## generate the data

data.gen <- GenerateData(n,p,m,qvs,censoring.rate,simu.setting,covariate.dependent)

x <- data.gen$x
delta <- data.gen$delta
q <- data.gen$q
ww <- data.gen$ww
zz <- data.gen$zz


## true group membership (needed to compute the AUC/BS for simulated data
true.groups <- data.gen$true.groups

## Perform the estimation			
estimators.out <- landmix.estimator(n,m,p,qvs,q,
				x,delta,ww,zz,
				run.NPNA,
				run.NPNA_avg,
				tval,tval0,
				z.use,w.use)
				

}

