% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/languageserver_detect.R
\name{languageserver_detect}
\alias{languageserver_detect}
\title{Detect whether a process relates to the R Language Server}
\usage{
languageserver_detect(pid, os, langServerProcessPatt, checkParents = TRUE)
}
\arguments{
\item{pid}{\code{integer(1)}, id of the process to investigate,
usually retrieved by \code{Sys.getpid}}

\item{os}{\code{character(1)}, name of the OS, usually retrieved
as the \code{"sysname"} element of \code{Sys.info}, all lowercase.}

\item{langServerProcessPatt}{\code{character(1)}, pattern to
recognize the process created by \code{languageserver}.}

\item{checkParents}{\code{logical(1)}, if \code{TRUE}, parent processes are also
checked in case when \code{pid} is not the R Language Server process. This
is needed as the linting processes are created with callr as
sub-processes of the main Language Server process.}
}
\value{
logical(1), \code{TRUE} if the process with \code{pid} (or, optionally,
any of its parents) is detected as the R Language Server process.
Otherwise \code{FALSE}.
}
\description{
Detect whether a process relates to the R Language Server
}
